'use client'
import { Button } from "@/components/ui/button";
import Image from "next/image";
import Link from "next/link";
import * as React from "react"
import Autoplay from "embla-carousel-autoplay"

import { Card, CardContent } from "@/components/ui/card"
import {
  Carousel,
  CarouselContent,
  CarouselItem,
  CarouselNext,
  CarouselPrevious,
} from "@/components/ui/carousel"
const data = [
  "موقع استراتيجي في حي الصفا بالقرب من طريق الأمير ماجد وحديقة البيروني",
  "وحدة سكنية بمساحة 201 مترًا مربعًا - مواجهة للجنوب، بتصميم فعال",
  "جاهز للتسليم الفوري - مع الوثائق القانونية الكاملة",
  "تشطيبات فاخرة بمعايير حديثة ومواد معتمدة",
  "بوابات الدخول الذكية ومواقف السيارات الآلية",
  "شهادة الإشغال الرسمية - مؤهلة للحصول على دعم الإسكان",
  "ضمان لمدة 10 سنوات ضد العيوب الهيكلية",
  "عدد محدود من الوحدات بمواصفات نادرة في هذه المنطقة السكنية",
];
const ReviewData=[
  {
    name: 'صالح احمد العواضى',
    comment: 'شركة المسكن الوافي من ارقي الشركات وافضلها تعامل واداء، فلهم مني كل الشكر والتقدير'
  },
  {
    name: 'ماجد الحربي',
  comment: "شكرا المسكن الوافي وشكرا دكتور مراد الزهراني على المصداقيه ، ووفقكم الله والى الامام ولنا عوده معكم باذن الله في مشاريع اخرى فريق محترم بتعامله ومصداقيته"

  },
  {
    name: 'Walid Hussin',
  comment: "شكر جزيل للقائمين علي شركة الوافي للتطوير العقاري من موظفيها على حسن استقبال والشرح الوافي من قبلهم صراحة المشروع كان ممتاز تمنيت ان يحالفني الحظ اني اتعاقد معهم من الرغم ان سعرهم كان فرصة طيبه باني امتلك عقار لكن الحمد لله تعرفت علي العقار عن طريق صديق لي وشف المخطط كان هندسة ممتازة والموقع ممتاز انصح لك احد التعامل معهم اجراتهم سلسه و محل ثقه و ان شاء الله يكون لي فرصة ثانيه معهم ...",

  },

]
export default function Page() {
  

  const plugin = React.useRef(
    Autoplay({ delay: 2000, stopOnInteraction: true })
  )

  return (
    <div className="py-4 ">
      <div className="bg-[url('/images/comingsoon/bg.jpg')] w-full h-fit pb-10 text-center mx-auto">
        <div className="flex items-center justify-center">
          <Link
            href="/"
            z="true"
            className="relative w-[40px] h-[40px] md:w-[60px] md:h-[60px] block"
          >
            <Image
              src="/images/sadu-logo.png"
              fill
              alt="sadu-logo"
              className="cursor-pointer object-contain"
            />
          </Link>
        </div>
        <h1 className="text-[30px] sm:text-[35px] md:text-[60px] mt-3 font-semibold">
          مرحبا بكم في <span className="text-primary">مسكن الصفا</span>
        </h1>
        <h6 className="text-[25px] sm:text-[30px] md:text-[40px] mt-3 sm:mt-6 md:mt-10">فرصة نادرة - لوحدة في قلب جدة</h6>
        <div className="text-center mx-auto flex flex-col items-center">
          <p className="sm:text-[18px] text-[#7C7C7C] lg:px-20 w-[90%] sm:w-[70%] md:w-[45%] py-4 text-center">
            جاهز للسكن - بمواصفات عالية وتشطيبات فاخرة وتصميم ذكي... مثالي للسكن
            أو الاستثمار
          </p>
          <p className="sm:text-[18px] text-[#7C7C7C] lg:px-20  w-[90%] sm:w-[70%] md:w-[45%] text-center">
            للحصول على مخططات معمارية ومواصفات المساحات وخيارات التسعير، تواصل
            مع فريقنا مباشرةً
          </p>
        </div>
        <div className="mt-5 px-5 md:px-[50px] lg:px-[96px] mx-auto">
          <video
            src="/images/comingsoon/vid.mp4"
            className=" rounded-2xl mx-auto "
            autoPlay
            loop
            muted
          />
        </div>
        <Link href="#">
          <Button className="rounded-full mx-auto mt-10 md:mt-20 text-white text-[16px] h-[40px] md:h-[40px] bg-[#012B3B] font-light">
            <Image
              src="/images/comingsoon/arrowWhite.png"
              alt="arrow"
              width={12}
              height={12}
              className="rotate-270"
            />
            اطلب ملف المشروع المفصل{" "}
          </Button>
        </Link>
      </div>

      <div className="text-center flex flex-col items-center sm:mt-10 md:mt-16">
        <h3 className="text-[40px] ">فوائد الملكية</h3>
        <p className="text-[16px] text-[#7C7C7C] lg:px-20 w-[90%] sm:w-[70%] md:w-[45%] text-center">
          ادخل إلى نمط حياة حيث تم تصميم كل التفاصيل لرفع مستوى تجربة المعيشة
          الخاصة بك - من الموقع المتميز إلى وسائل الراحة الحديثة، وهذا هو المكان
          الذي يبدأ فيه مستقبلك.
        </p>
        <section className="bg-white px-5 md:px-[50px] lg:px-[96px] w-full py-5 sm:py-16 md:flex gap-[30px] lg:gap-[64px] justify-between items-center">
          <div className="md:w-1/2 flex justify-end mt-8 md:mt-0">
            <div className="relative w-full md:max-w-[680px] h-[370px] mx-auto">
              <div className="absolute top-0 left-0 rounded-xl">
                <div className="relative w-[280px] sm:w-[450px] md:w-[300px] h-[220px] sm:h-[300px] md:h-[250px] lg:w-[400px] lg:h-[370px]">
                  <Image
                    src="/images/comingsoon/Rectangle 30.png"
                    alt="City"
                    fill
                    className="rounded-xl absolute top-0 left-0"
                  />
                </div>
              </div>
              <div className="absolute bottom-[50px] sm:bottom-[-1px] md:bottom-[20px] lg:bottom-[-50px] left-[11%] sm:left-[250px]  md:left-[35%] lg:left-[30%] rounded-xl">
                <div className="relative w-[250px] sm:w-[300px]  md:w-[220px] h-[180px] sm:h-[220px] md:h-[150px] lg:w-[359px] lg:h-[200px]">
                  <Image
                    src="/images/comingsoon/Rectangle 32.png"
                    alt="City"
                    fill
                    className="rounded-xl absolute bottom-[-50px] left-[1%] lg:left-[20%]"
                  />
                </div>
              </div>
            </div>
          </div>
          <div className="md:w-1/2 space-y-4 mt-10 md:mt-0">
            {data.map((d, i) => (
              <div key={i} className="flex flex-row-reverse items-center gap-4">
                <div className="h-[18px] w-[18px] shrink-0 rounded-full bg-primary"></div>
                <p>{d}</p>
              </div>
            ))}
          </div>
        </section>
      </div>
     

      <div className="bg-[url('/images/comingsoon/Rectangle.png')] w-full mx-auto text-center pb-10 pt-16 mt-4">
        <h3 className="text-[30px] sm:text-[40px]">استثمارك محمي بالكامل</h3>
        <p className="text-[16px] text-[#7C7C7C] lg:px-20 w-[90%] sm:w-[45%] text-center mx-auto py-6">
          يغطي الضمان العيوب الهيكلية والتشطيبية المخفية، ويصدره طرف معتمد
          وينطبق على كل وحدة عند التسليم
        </p>
        <Button className="rounded-full mx-auto mt-4 text-white text-[16px] h-[40px] md:h-[40px] bg-[#012B3B] font-light">
          تحدث مع مستشار السدو
        </Button>
      </div>
      <div className="mt-14 mb-5 border-b-2 pb-8 mx-5 md:mx-[50px] lg:mx-[96px]">
        <h3 className="text-center text-[20px] pb-7 flex items-center gap-2 justify-center">
          <Image
            src="/images/comingsoon/Group (1).png"
            alt="arrow"
            width={12}
            height={12}
            className=""
          />{" "}
          خطة الملكية
        </h3>

        <div className="grid sm:grid-cols-2 gap-5 pb-8  text-end ">
          {[0,1].map((_,i)=>(

          <div className="bg-[#F1F1F1] p-3 pt-5 rounded-lg">
            <h4 className="text-[20px] lg:text-[24px]">
              الخطة ب – 170 متر مربع + 34 متر مربع سطح خاص.
            </h4>
            <p className="text-[12px] lg:text-[16px] text-[#7C7C7C]">
              تتضمن: 3 غرف نوم، خزانة ملابس، غرفة معيشة، غرفة طعام، مطبخ، غرفة
              خادمة، غرفة غسيل، مخزن، 4 حمامات، وصالون للضيوف.
            </p>
            <p className="text-[12px] lg:text-[16px] text-[#7C7C7C]">
              "مصمم خصيصًا للعائلات الصغيرة والمتوسطة الحجم التي تبحث عن الراحة
              والقيمة المضافة المتمثلة في الوصول إلى السطح."
            </p>
            <div className="relative w-full h-[180px] sm:h-[220px] lg:h-[369px]">
              <Image
                src="/images/comingsoon/Rectangle 31.png"
                alt="City"
                fill
                className="rounded-xl absolute bottom-[-50px] left-[1%] lg:left-[20%]"
              />
            </div>
          </div>
          ))}
          
        </div>
         <div className="md:flex items-center  ">
        <div className="relative h-[1000px] w-full md:w-1/2 mb-5 md:mb-0">

         <Image
              src="/images/comingsoon/Sadu1.png"
              alt="arrow"
              fill
              className="rounded-2xl md:rounded-tl-2xl md:rounded-bl-2xl"
            />
        </div>
        <div className="relative h-[1000px] w-full md:w-1/2 ">

         <Image
              src="/images/comingsoon/Sadu2.png"
              alt="arrow"
              fill
              className="rounded-2xl md:rounded-tr-2xl md:rounded-br-2xl"
            />
        </div>
        </div>
      </div>

      <div>
        <h3 className="text-center text-[20px] pt-5 pb-7 flex items-center gap-2 justify-center mx-auto">
          <Image
            src="/images/comingsoon/Group (1).png"
            alt="arrow"
            width={12}
            height={12}
            className=""
          />{" "}
          خطة الملكية
        </h3>
        <h2 className="text-[30px] sm:text-[40px] lg:px-20 w-[90%] sm:w-[50%] mx-auto text-center">
          بعض التفاصيل تتحدث قبل أن تظهر
        </h2>

        {/* //carousal */}




    <Carousel
      // plugins={[plugin.current]}
      className="w-full mt-5 h-[300px] md:h-[400px] lg:h-[500px] px-5 md:px-[50px] lg:px-[96px]"
      // onMouseEnter={plugin.current.stop}
      // onMouseLeave={plugin.current.reset}
    >
      <CarouselContent className='rounded-lg'>
        {Array.from({ length: 5 }).map((_, index) => (
          <CarouselItem key={index} className='h-[300px] md:h-[400px] lg:h-[500px] relative'>
             <div className="relative w-full h-full rounded-xl">
                  <Image
                    src="/images/comingsoon/Rectangle 41.png"
                    alt="City"
                    fill
                    className=" "
                  />
                </div>
                <p className="absolute bottom-10 text-end sm:bottom-2 left-6 backdrop-blur-sm text-white">ما تبدأ به المواصفات، وتكتمل به الصور</p>
                <p className="absolute bottom-4 sm:bottom-2 right-4 text-white">390,000.00 ريال سعودي</p>
          </CarouselItem>
        ))}
      </CarouselContent>
      <CarouselPrevious className='left-[39%] sm:left-[45%] lg:left-[47%] top-[100%]' />
      <CarouselNext className='right-[39%] sm:right-[45%] lg:right-[47%] top-[100%]' />
    </Carousel>
  







        {/* //carousla end */}
        <div className="mx-auto w-full flex items-center justify-center pt-6">
          <Button className="rounded-full mx-auto mt-4 text-white text-[16px] h-[40px] md:h-[40px] bg-[#012B3B] font-light">
            اطلب ملف المشروع الكامل
          </Button>
        </div>
      </div>

      <div className="sm:mt-10">
        <h2 className="text-[30px] sm:text-[40px] lg:px-20 w-[90%] sm:w-[40%] py-8 mx-auto text-center">
         تجارب حقيقية من عملاء سدو
        </h2>
        <div className="grid sm:grid-cols-2 md:grid-cols-3 gap-4 px-5 md:px-[50px] lg:px-[96px] text-end">
          {ReviewData.map((review,index)=>(

          <div key={index} className="flex flex-col justify-between bg-[#F8F8F8] rounded-lg p-6 text-[14px] lg:text-[16px]">
            <div>
            <div className="flex items-center justify-between">
              <Image
                src="/images/comingsoon/Black.png"
                alt="arrow"
                width={40}
                height={28}
                className=""
              />
              <Image
                src="/images/comingsoon/Group 54.png"
                alt="arrow"
                width={120}
                height={28}
                className=""
              />
            </div>
            <p className="py-4">
              {review.comment}
            </p>
            {/* <p className="pb-10 pt-3">
              منذ اللحظة التي دخلتُ فيها مكتبهم، شعرتُ بترحيب ودعم من فريقهم
              الودود.
            </p> */}
            </div>
            <div className="flex items-center justify-end gap-2 pt-5">
               <Image
                src="/images/comingsoon/Vector (21).png"
                alt="arrow"
                width={40}
                height={28}
                className=""
              />
              <div className="text-[14px] lg:text-[16px]">
                <p className="font-semibold">{review?.name}</p>
                <p>استشارة الملكية</p>
              </div>
                <Image
                src="/images/comingsoon/Ellipse 13.png"
                alt="arrow"
                width={40}
                height={28}
                className=""
              />
            </div>
          </div>
          ))}
        </div>
        <div className="mx-auto w-full flex items-center justify-center mt-5">
          <Button className="rounded-full mx-auto mt-4 text-white text-[16px] h-[40px] md:h-[40px] bg-[#012B3B] font-light">
اطلب ملف المشروع الكامل    
      </Button>
        </div>
      </div>
    </div>
  );
}
