'use client'
import { Badge } from "@/components/ui/badge";
import { Button } from "@/components/ui/button";
import Image from "next/image";
import React from "react";
import { useTranslation } from "react-i18next";

const OurTeam = () => {
        const { t } = useTranslation("about");
  
  const articles = [
    {
      title: t("Ahmed Khan"),
      image: '/images/arbi1.png',
      role: t("Subtitle1"),
      desc: t("Description"),
    },
    {
      title: t("Bilal Hussain"),
       image: '/images/arbi2.png',
      role: t("Subtitle2"),
      desc: t("Description2"),
    },
    {
      title: t("Kashif Ahmad"),
       image: '/images/arbi3.png',
      role: t("Subtitle3"),
      desc: t("Description3"),
    },
  ];
  return (
    <div className="text-center px-5 md:px-[50px] lg:px-[96px] pb-5 md:pb-8 lg:pb-20 bg-ligbg pt-10">
      <div className=" text-primary mb-2 font-semibold">{t("TEAM")}</div>
      <h2 className="text-[30px] md:text-[35px] lg:text-[40px] font-semibold mb-0">
        {t("Our")} <span className="text-primary">{t("Team")}</span>
      </h2>
      <p className="lg:px-19 mx-auto mb-5 lg:mb-9 text-[#808080] w-full sm:max-w-[75%] md:max-w-[67%]">
       {t("OurTeam Desc")}
      </p>

      <div className="grid sm:grid-cols-2 md:grid-cols-3 gap-[15px] lg:gap-[30px] text-start mb-8">
        {articles.map((article, index) => (
          <div key={index} className=" h-[400px] sm:h-[450px] lg:h-[490px] relative rounded-2xl">
            <div className="relative w-full h-full ">
              <Image
                src={article.image}
                alt="City"
                fill
                className="rounded-xl"
              />
            </div>
            <div className="bg-white px-3 lg:px-6 py-3 lg:py-4 rounded-2xl absolute bottom-6 mx-4">
              <p className="text-[18px] font-bold">{article.title}</p>
              <p className="text-[14px] font-medium text-primary py-1 lg:py-2">
                {article.role}
              </p>
              <p className="text-[13px] lg:text-[14px] font-light mb-2 lg:mb-4">{article.desc}</p>
              <div className="flex gap-4 items-center">
                 <Image
                src="/icons/fb.png"
                alt="City"
                width={16}
                height={16}
              /> <Image
                src="/icons/linkedin (2).png"
                alt="City"
                width={16}
                height={16}
              />
              </div>
            </div>
          </div>
        ))}
      </div>
     
    </div>
  );
};

export default OurTeam;
