"use client"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Separator } from "@/components/ui/separator";
import { Badge } from "@/components/ui/badge";
import Image from "next/image";
import { useTranslation } from "react-i18next";

export function ClientTestimonials() {
      const { t } = useTranslation("home");
  const testimonials = [
    {
      name: ("Ticket Altmod"),
      comment: "across a huge area.",
      testimonial: "Smart team guides marketing through our investment in Riyadh. Their professionalized and learning speed out, making the process seamless and secure time."
    },
    {
      name: "All Memos",
      comment: "increase its length.",
      testimonial: "Social Vision guides quarterly through our investment in Shayat. Their professionalized and learning speed out, making the process seamless and green-time."
    },
    {
      name: "Inhomemoral All",
      comment: "increase its length.",
      testimonial: "Social Vision guides quarterly through our investment in Shayat. Their professionalized and learning speed out, making the process seamless and green-time."
    }
  ];

  

  return (
    <div className="text-center mx-auto px-5 md:px-[50px] lg:px-[96px] py-10 lg:py-15 bg-ligbg">
       <div className=" text-primary mb-2 font-semibold">{t("TESTIMONIALS")}</div>
      <h2 className="text-[30px] md:text-[35px] lg:text-[40px] font-semibold mb-0">
       {t("What")}  <span className="text-primary">{t("Our Clients")}</span> {t("Say")} 
      </h2>
      <p className="sm:px-8 md:px-12 lg:px-19 mx-auto mb-9 text-[#808080] w-full md:max-w-[80%] lg:max-w-[67%]">
      {t("testimonilas description")}
      </p>

      <div className="grid sm:grid-cols-2 md:grid-cols-3 gap-4 lg:gap-6 ">
        {testimonials.map((testimonial, index) => (
          <Card key={index} className="border-none shadow-none gap-3 lg:gap-[24px]">
            
            <CardHeader className='flex gap-2 lg:gap-[14px] px-4 lg:px-6'>
              <div className="relative w-[56px] h-[56px]">
              <Image   src='/images/aadmi.png'
              alt="City"
              fill
              className="rounded-full" />
            </div>
            <div className="text-start">

              <CardTitle className=" text-[16px] lg:text-lg font-semibold">{testimonial.name}</CardTitle>
              <p className="text-[14px] lg:text-[16px]">{testimonial.comment}</p>
            </div>
            </CardHeader>
            <CardContent className='px-4 lg:px-6'>
              <p className="text-start text-[16px] lg:text-[18px] ">{testimonial.testimonial}</p>
            </CardContent>
          </Card>
        ))}
      </div>
    </div>
  );
}