"use client";

import { useTranslation } from "@/lib/i18n";
import HeroSection from "./HeroSection";

export default function HeroParent({isAbout, isBlogs, isBtn,isProperties,isContact,isServices,isHome}) {
  
  const { t } = useTranslation(isAbout ? "about": isBlogs? "blogs" : isProperties? "properties": isContact? "contact": isServices? "services": "home");

  return (
   <HeroSection
  head={t("head")}
  title={t("title")}
      isBtn={isBtn}

  description={t("description")}
  {...((!isBlogs && !isProperties && !isContact && !isServices && !isHome) && {
    description2: t("description2"),
    titleHighlight: t("titleHighlight"),
  })}
/>

  );
}
