'use client'
import React from "react";
import NavHead from "./NavHead";
import Image from "next/image";
import { Button } from "@/components/ui/button";
import Link from "next/link";
import { useRouter } from "next/navigation";

const NavbarAuth = () => {
  
    const router = useRouter();

  return (
    <div>
      <NavHead />
      <div className="flex items-center justify-between px-5 md:px-[50px]  lg:px-[96px] py-[10px] ">
          <div className="relative w-[40px] h-[40px] md:w-[60px] md:h-[60px]">
        <Image
          onClick={() => router.push('/')}

          src="/images/sadu-logo.png" 
        fill
          alt="sadu-logo"
        /></div>
        <div className="flex items-center justify-center gap-3 md:gap-[27px]">
          <div className="flex items-center justify-center text-[16px]">
            <div className="relative w-[18px] h-[18px]">
            <Image
              src="/icons/person.png"
fill
              alt="sadu-logo"
              className=""
            />
            </div>
            <div className="flex items-center justify-center ps-1 text-[14px]  md:text-[16px] ">
              <Link href="/login">Login</Link>/<Link href="/signup">Register</Link>
            </div>
          </div>
          <Button className="bg-primary text-[12px] md:text-[14px]  h-[35px] md:h-[50px]">Click me</Button>
        </div>
      </div>
    </div>
  );
};

export default NavbarAuth;
