// // import React from 'react'

// // const SignUp = () => {
// //   return (
// //     <div>SignUp</div>
// //   )
// // }

// // export default SignUp

// import {
//   Card,
//   CardAction,
//   CardContent,
//   CardDescription,
//   CardFooter,
//   CardHeader,
//   CardTitle,
// } from "@/components/ui/card"

// export function SignUp() {
//   return (
//    <Card>
//   <CardHeader>
//     <CardTitle>Card Title</CardTitle>
//     <CardDescription>Card Description</CardDescription>
//     <CardAction>Card Action</CardAction>
//   </CardHeader>
//   <CardContent>
//     <p>Card Content</p>
//   </CardContent>
//   <CardFooter>
//     <p>Card Footer</p>
//   </CardFooter>
// </Card>
//   )
// }

// "use client";
// import { Button } from "@/components/ui/button";
// import {
//   Card,
//   CardAction,
//   CardContent,
//   CardDescription,
//   CardFooter,
//   CardHeader,
//   CardTitle,
// } from "@/components/ui/card";
// import { Input } from "@/components/ui/input";
// import { Label } from "@/components/ui/label";
// import Image from "next/image";
// import Link from "next/link";
// import { useState } from "react";

// export function SignUp() {
//   const [formData, setFormData] = useState({
//     name: "",
//     email: "",
//     phone_no: "",
//     password: "",
//     password_confirmation: "",
//   });
//   const [loading, setLoading] = useState(false);
// const [error, setError] = useState({ errors: {} });
//   const handleChange = (e) => {
//     setFormData((prev) => ({
//       ...prev,
//       [e.target.name]: e.target.value,
//     }));
//   };
//   const handleSubmit = async (e) => {
//     e.preventDefault();
//     setLoading(true);
//     setError(null);

//     try {
//       const res = await fetch("https://sadu.reownlogics.com/api/register", {
//         method: "POST",
//         headers: {
//           "Content-Type": "application/json",
//         },
//         body: JSON.stringify(formData),
//       });

//       const result = await res.json();

//       if (!res.ok) {
//         setError(result || "Something went wrong");
//       } else {
//         window.location.href = "/login";
//       }
//     } catch (err) {
//       setError("Failed to register. Please try again.");
//     } finally {
//       setLoading(false);
//     }
//   };
//   return (
//     <Card className="w-full h-full py-5 md:py-[35px]">
//       <CardHeader className="text-center  px-4 md:px-6">
//         <CardTitle className="text-center text-xl sm:text-[27px]  lg:text-[38px]">
//           Signup
//         </CardTitle>
//         <CardDescription className="text-[14px] sm:text-[16px]">
//           Create an account to unlock exclusive features.
//         </CardDescription>
//       </CardHeader>
//       <CardContent className=" px-4 md:px-6">
//         <form onSubmit={handleSubmit}>
//           <div className="flex flex-col gap-2">
//             <div className="grid gap-1">
//               <Label
//                 className="text-[14px] sm:text-[16px] font-medium text-[#262626]"
//                 htmlFor="name"
//               >
//                 Full Name
//               </Label>
//               <Input
//                 id="name"
//                 type="text"
//                 name="name"
//                 value={formData.name}
//                 onChange={handleChange}
//                 placeholder="Enter your Name"
//                 required
//                 className="h-11 lg:h-[60px] text-[14px] sm:text-[16px]"
//               />
//             </div>
//             <div className="grid gap-1">
//               <Label
//                 className="text-[14px] sm:text-[16px] font-medium text-[#262626]"
//                 htmlFor="email"
//               >
//                 Email
//               </Label>
//               <Input
//                 id="email"
//                 type="email"
//                 name="email"
//                 value={formData.email}
//                 onChange={handleChange}
//                 placeholder="Enter your Email"
//                 required
//                 className="h-11 lg:h-[60px] text-[14px] sm:text-[16px]"
//               />
//             </div>
//             <div className="grid gap-1">
//               <Label
//                 className="text-[14px] sm:text-[16px] font-medium text-[#262626]"
//                 htmlFor="email"
//               >
//                 Phone
//               </Label>
//               <Input
//                 id="phone"
//                 name="phone_no"
//                 type="tel"
//                 value={formData.phone_no}
//                 onChange={handleChange}
//                 placeholder="Enter your Phone Number"
//                 required
//                 className="h-11 lg:h-[60px] text-[14px] sm:text-[16px]"
//               />
//             </div>
//             <div className="grid gap-1">
//               <div className="flex items-center">
//                 <Label
//                   className="text-[14px] sm:text-[16px]"
//                   htmlFor="password"
//                 >
//                   Password
//                 </Label>
//               </div>
//               <Input
//                 className="h-11 lg:h-[60px] text-[14px] sm:text-[16px]"
//                 id="password"
//                 type="password"
//                 name="password"
//                 value={formData.password}
//                 onChange={handleChange}
//                 placeholder="Enter your Password"
//                 required
//               />
//             {Boolean(error?.errors?.password) && (
//   <small className="text-red-500 text-xs">
//     {error.errors.password[0]}
//   </small>
// )}

//             </div>
//             <div className="grid gap-1">
//               <div className="flex items-center">
//                 <Label
//                   className="text-[14px] sm:text-[16px]"
//                   htmlFor="password_confirmation"
//                 >
//                   Confirm Password
//                 </Label>
//               </div>
//               <Input
//                 className="h-11 lg:h-[60px] text-[14px] sm:text-[16px]"
//                 id="password_confirmation"
//                 type="password"
//                 name="password_confirmation"
//                 value={formData.password_confirmation}
//                 onChange={handleChange}
//                 placeholder="Confirm your Password"
//                 required
//               />
//             </div>
//           </div>
//         </form>
//         {error && <p className="text-red-500 text-sm mt-2">{error}</p>}
//       </CardContent>
//       <CardFooter className="flex-col gap-2  px-4 md:px-6">
//         <label
//           className="flex gap-2 flex-wrap text-[14px] sm:text-[16px]"
//           style={{ alignSelf: "start" }}
//         >
//           <input
//             type="checkbox"
//             className="w-[18px] h- [18px] lg:h-[24px] lg:w-[24px]"
//           />
//           I agree with
//           <Link className="underline whitespace-nowrap" href="/login">
//             {" "}
//             Terms of Use
//           </Link>{" "}
//           and{" "}
//           <Link className="underline whitespace-nowrap" href="/login">
//             {" "}
//             Privacy Policy
//           </Link>
//         </label>
//         <Button
//           onClick={handleSubmit}
//           type="submit"
//           className="w-full md:h-11 lg:h-[60px] my-2"
//            disabled={Object.values(formData).some(value => !value.trim()) || loading}
//         >
//           {loading ? "Signing up..." : "Sign Up"}
//         </Button>
//         <div className="flex gap-[12px] w-full items-center">
//           <span className="w-full bg-[#E4E4E7] h-[1px]"></span>
//           OR
//           <span className="w-full bg-[#E4E4E7] h-[1px]"></span>
//         </div>
//         <Button className="w-full bg-[#F7F7F8] text-black md:h-11 lg:h-[60px] ">
//           <Image
//             src="/icons/googleIcons.png"
//             width={24}
//             height={24}
//             alt="google"
//           />
//           Sign Up with Google
//         </Button>
//         <div className="py-[5px]">
//           <div className="flex items-center gap-1 text-[14px] sm:text-[16px]">
//             <p>Already have an account?</p>
//             <Link className="underline font-medium" href="/login">
//               {" "}
//               Login
//             </Link>
//             <img
//               className="h-[11px] w-[11px]"
//               src="/icons/arrow.png"
//               alt="arrow"
//             />
//           </div>
//         </div>
//       </CardFooter>
//     </Card>
//   );
// }


"use client";
import { Button } from "@/components/ui/button";
import {
  Card,
  CardContent,
  CardDescription,
  CardFooter,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { baseUrl } from "@/lib/config";
import Image from "next/image";
import Link from "next/link";
import { useState } from "react";
import { useTranslation } from "react-i18next";

export function SignUp() {
          const { t } = useTranslation("signup"); 
  
  const [formData, setFormData] = useState({
    name: "",
    email: "",
    phone_no: "",
    password: "",
    password_confirmation: "",
  });

  const [loading, setLoading] = useState(false);

  // Always keep a predictable shape to avoid rendering issues
  const [error, setError] = useState({ message: "", errors: {} });

  const handleChange = (e) => {
    setFormData((prev) => ({
      ...prev,
      [e.target.name]: e.target.value,
    }));
  };

  const handleSubmit = async (e) => {
    e.preventDefault();
    setLoading(true);
    setError({ message: "", errors: {} });

    try {
      const res = await fetch(`${baseUrl}/api/register`, {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
        },
        body: JSON.stringify(formData),
      });

      const result = await res.json();

      if (!res.ok) {
        setError({
          message: result.message || "Something went wrong",
          errors: result.errors || {},
        });
      } else {
        window.location.href = "/login";
      }
    } catch {
      setError({
        message: "Failed to register. Please try again.",
        errors: {},
      });
    } finally {
      setLoading(false);
    }
  };

  return (
    <Card className="w-full h-full py-5 md:py-[35px]">
      <CardHeader className="text-center px-4 md:px-6">
        <CardTitle className="text-center text-xl sm:text-[27px] lg:text-[38px]">
          {t("Signup")}
        </CardTitle>
        <CardDescription className="text-[14px] sm:text-[16px]">
          {t("Create an account to unlock exclusive features.")}
        </CardDescription>
      </CardHeader>
      <CardContent className="px-4 md:px-6">
        <form onSubmit={handleSubmit}>
          <div className="flex flex-col gap-2">
            {/* Name */}
            <div className="grid gap-1">
              <Label
                className="text-[14px] sm:text-[16px] font-medium text-[#262626]"
                htmlFor="name"
              >
                {t("Full Name")}
              </Label>
              <Input
                id="name"
                type="text"
                name="name"
                value={formData.name}
                onChange={handleChange}
                placeholder={t("Enter your Name")}
                required
                className="h-11 lg:h-[60px] text-[14px] sm:text-[16px]"
              />
              <small className="text-red-500 text-xs">
                {error.errors.name?.[0] || ""}
              </small>
            </div>

            {/* Email */}
            <div className="grid gap-1">
              <Label
                className="text-[14px] sm:text-[16px] font-medium text-[#262626]"
                htmlFor="email"
              >
                {t("Email")}
              </Label>
              <Input
                id="email"
                type="email"
                name="email"
                value={formData.email}
                onChange={handleChange}
                placeholder={t("Enter your Email")}
                required
                className="h-11 lg:h-[60px] text-[14px] sm:text-[16px]"
              />
              <small className="text-red-500 text-xs">
                {error.errors.email?.[0] || ""}
              </small>
            </div>

            {/* Phone */}
            <div className="grid gap-1">
              <Label
                className="text-[14px] sm:text-[16px] font-medium text-[#262626]"
                htmlFor="phone_no"
              >
                {t("Phone")}
              </Label>
              <Input
                id="phone_no"
                name="phone_no"
                type="tel"
                value={formData.phone_no}
                onChange={handleChange}
                placeholder={t("Enter your Phone Number")}
                required
                className="h-11 lg:h-[60px] text-[14px] sm:text-[16px]"
              />
              <small className="text-red-500 text-xs">
                {error.errors.phone_no?.[0] || ""}
              </small>
            </div>

            {/* Password */}
            <div className="grid gap-1">
              <Label
                className="text-[14px] sm:text-[16px]"
                htmlFor="password"
              >
                {t("Password")}
              </Label>
              <Input
                className="h-11 lg:h-[60px] text-[14px] sm:text-[16px]"
                id="password"
                type="password"
                name="password"
                value={formData.password}
                onChange={handleChange}
                placeholder={t("Enter your Password")}
                required
              />
              <small className="text-red-500 text-xs">
                {error.errors.password?.[0] || ""}
              </small>
            </div>

            {/* Confirm Password */}
            <div className="grid gap-1">
              <Label
                className="text-[14px] sm:text-[16px]"
                htmlFor="password_confirmation"
              >
                {t("Confirm Password")}
              </Label>
              <Input
                className="h-11 lg:h-[60px] text-[14px] sm:text-[16px]"
                id="password_confirmation"
                type="password"
                name="password_confirmation"
                value={formData.password_confirmation}
                onChange={handleChange}
                placeholder={t("Confirm your Password")}
                required
              />
              <small className="text-red-500 text-xs">
                {error.errors.password_confirmation?.[0] || ""}
              </small>
            </div>
          </div>

          {/* General error */}
          {error.message && (
            <p className="text-red-500 text-sm mt-2">{error.message}</p>
          )}

          <Button
            type="submit"
            className="w-full md:h-11 lg:h-[60px] my-4"
            disabled={Object.values(formData).some((v) => !v.trim()) || loading}
          >
            {loading ? t("Signing up...") : t("Sign Up")}
          </Button>
        </form>
      </CardContent>
      <CardFooter className="flex-col gap-2 px-4 md:px-6">
        <label
          className="flex gap-2 flex-wrap text-[14px] sm:text-[16px]"
          style={{ alignSelf: "start" }}
        >
          <input
            type="checkbox"
            className="w-[18px] h-[18px] lg:h-[24px] lg:w-[24px]"
          />
          {t("I agree with")}
          <Link className="underline whitespace-nowrap" href="/login">
            {" "}
           {t("Terms of Use")}
          </Link>{" "}
          {t("and")}{" "}
          <Link className="underline whitespace-nowrap" href="/login">
            {" "}
           {t("Privacy Policy")}
          </Link>
        </label>
        <div className="flex gap-[12px] w-full items-center">
          <span className="w-full bg-[#E4E4E7] h-[1px]"></span>
          {t("OR")}
          <span className="w-full bg-[#E4E4E7] h-[1px]"></span>
        </div>
        <Button className="w-full bg-[#F7F7F8] text-black md:h-11 lg:h-[60px]">
          <Image
            src="/icons/googleIcons.png"
            width={24}
            height={24}
            alt="google"
          />
          {t("Sign Up with Google")}
        </Button>
        <div className="py-[5px]">
          <div className="flex items-center gap-1 text-[14px] sm:text-[16px]">
            <p>{t("Already have an account?")}</p>
            <Link className="underline font-medium" href="/login">
              {" "}
              {t("Login")}
            </Link>
            <img
              className="h-[11px] w-[11px]"
              src="/icons/arrow.png"
              alt="arrow"
            />
          </div>
        </div>
      </CardFooter>
    </Card>
  );
}
