"use client"
import { Card, CardContent, CardHeader } from "@/components/ui/card";
import Image from "next/image";
import React from "react";
import { useTranslation } from "react-i18next";

const WhatSetsAsApart = ({isAboutPage}) => {
          const { t } = useTranslation("WhatSetsUsApart");
  
  const features = [
    {
      title: t("Saudi Real Estate Experts"),
      icon: "/icons/setsApart/Group 1321315257.png",
      description:
        t("Saudi Real Estate ExpertsD")
    },
    {
      title: t("Personalized Client Service"),
      icon: "/icons/setsApart/Group 1321315258.png",
      description:
       t("Personalized Client ServiceD")
    },
    {
      title: t("Transparent & Ethical Practices"),
      icon: "/icons/setsApart/Group 1321315259.png",
      description: t("Transparent & Ethical PracticesD"),
    },
    {
      title: t("Technology-Driven Process"),
      icon: "/icons/setsApart/Group 1321315261.png",

      description:
        t("Technology-Driven ProcessD")
    },
    {
      title: t("Extensive Network"),
      icon: "/icons/setsApart/Group 1321315260.png",
      description:
       t("Extensive NetworkD"),
    },
  ];
  return (
    <div className="pb-10 ">
    <div className={`text-center px-5 md:px-[50px] lg:px-[96px] py-5 lg:py-8 ${isAboutPage? 'bg-ligbg': null}`}>
      <div className=" text-primary mb-2 font-semibold">{t("WHY CHOOSE US")}</div>
      <h2 className="text-[30px] md:text-[35px] lg:text-[40px] font-semibold mb-3">{t("What Sets Us Apart")}</h2>
      <div className="flex flex-wrap justify-center items-center gap-3 md:gap-4 lg:gap-6">
        {features.map((feature, index) => (
          <div
            key={index}
            className=" text-center w-[90%] sm:max-w-[45%] rounded-xl min-h-[250px] sm:min-h-[300px] md:min-h-[300px] max-h-[400px] h-full md:max-w-[31%] border-0 shadow-none gap-0 flex flex-col py-3"
          >
            <Image
              src={feature?.icon}
              alt="City"
              width={94}
              height={94}
              className="rounded-xl self-center"
            />
            <div>
              <h3 className="font-semibold text-xl lg:text-2xl pt-4 ">
                {feature.title}
              </h3>
              <p className="text-[#808080] text-[16px] lg:text-[18px] ">
                {feature.description}
              </p>
            </div>
          </div>
        ))}
      </div>
    </div>
    </div>
  );
};

export default WhatSetsAsApart;
