'use client'
import { articles } from "@/app/data/blogData";
import { Badge } from "@/components/ui/badge";
import { Button } from "@/components/ui/button";
import Image from "next/image";
import Link from "next/link";
import React from "react";
import { useTranslation } from "react-i18next";

const BlogInHome = ({ data }) => {
        const { t } = useTranslation("home");
  
  // const articles = [
  //   {
  //     title: "Generate $50 for this share home buyers your complete guide.",
  //     date: "Dear St. 2024",
  //   },
  //   {
  //     title: "Managing the most anxious tips for renters and tasteless.",
  //     date: "Dear St. 2024",
  //   },
  //   {
  //     title: "Checking the best neighborhood for your family's direct guide.",
  //     date: "",
  //   },
  // ];
  return (
    <div className="text-center px-5 md:px-[50px] lg:px-[96px] mt-10 lg:mt-15 pb-10 md:pb-15 lg:pb-20">
      <div className=" text-primary mb-2 font-semibold">{t("BLOGS")}</div>
      <h2 className="text-[30px] md:text-[35px] lg:text-[40px] font-semibold mb-0">
        {t("Stay")} <span className="text-primary">{t("Informed")}</span>
      </h2>
      <p className="sm:px-8 md:px-12 lg:px-19 mx-auto mb-5 lg:mb-9 text-[#808080] md:max-w-[80%] lg:max-w-[67%]">
      {t("blog description")} {" "}
      </p>

      <div className="grid sm:grid-cols-2 md:grid-cols-3 gap-[20px] lg:gap-[30px] text-start mb-5 lg:mb-8 ">
        {data?.slice(0, 3).map((article, index) => (
          <div key={article?.id} className="group ">
            <div className="relative w-full h-[300px] md:h-[350px] lg:h-[420px]">
              <Image
                src={article?.featuredImage?.url}
                alt={article?.featuredImage?.alt}
                fill
                className="rounded-lg"
              />
              {/* Overlay on hover */}
              <div className="absolute rounded-lg inset-0 bg-black/80 opacity-0 group-hover:opacity-100 transition duration-300"></div>

              {/* Icon on hover */}
              <div className="absolute cursor-pointer inset-0 flex items-center justify-center opacity-0 group-hover:opacity-100 transition duration-300">
                <Link
                  href={`/blog/${article?.slug}`}
                  className="cursor-pointer flex"
                >
                  <Image
                    src="/icons/arrowWhite.png"
                    alt="arrow"
                    width={20}
                    height={20}
                  />{" "}
                </Link>
              </div>
            </div>

            {article.date && (
              <p className="my-1 lg:my-2">{article.date.split("T")[0]}</p>
            )}
            <p className="text-[14px] md:text-[16px] lg:text-[18px]">
              {article.title}
            </p>
          </div>
        ))}
      </div>
      <Link href="/blogs">
        <Button className="bg-primary mx-auto mt-4 text-white text-[16px] font-normal">
          {t("View All Articles")}{" "}
          <Image
            src="/icons/arrowWhite.png"
            alt="arrow"
            width={12}
            height={12}
          />
        </Button>
      </Link>
    </div>
  );
};

export default BlogInHome;
