'use client'
import { articles } from '@/app/data/blogData';
import { Button } from '@/components/ui/button';
import Image from 'next/image';
import Link from 'next/link';
import { useRouter } from 'next/navigation';
import React from 'react'
import { useTranslation } from 'react-i18next';

const RelatesBlogs = ({relatedBlogs}) => {
    const { t }=useTranslation("blogDetail")
  
    const router = useRouter();
  
   
  return (
    <div className="text-center px-5 md:px-[50px] lg:px-[96px] mt-1 pb-10 md:pb-13 lg:pb-20">
      <h1 className=" text-primary mb-2 font-semibold">{t("BLOG")}</h1>
      <h2 className="text-[30px] md:text-[35px] lg:text-[40px] font-semibold mb-5">
        {t("Related")} <span className="text-primary ">{t("Blogs")}</span>
      </h2>
      <div className="grid sm:grid-cols-2 md:grid-cols-3 gap-[20px] lg:gap-[30px] text-start mb-5 md:mb-8 ">
        {relatedBlogs?.map((article, index) => (
          <div key={index} className="group ">
            <div className="relative w-full h-[300px] md:h-[350px] lg:h-[420px]">
              <Image
                src="/images/house/image 24.png"
                alt="City"
                fill
                className="rounded-lg"
              />
              {/* Overlay on hover */}
            <div className="absolute rounded-lg inset-0 bg-black/80 opacity-0 group-hover:opacity-100 transition duration-300"></div>

            {/* Icon on hover */}
            <div onClick={() => router.push(`/blog/${article?.slug}`)} className="cursor-pointer absolute inset-0 flex items-center justify-center opacity-0 group-hover:opacity-100 transition duration-300">
             <Image
          src="/icons/arrowWhite.png"
          alt="arrow"
          width={20}
          height={20}
        />
            </div>
            </div>

            {article.date && <p className="mt-1 md:my-2 text-[14px] md:text-[16px]">{article.date}</p>}
            <p className="text-[14px] md:text-[16px]">{article.title}</p>
          </div>
        ))}
      </div>
      <Link href='/blogs'>
      <Button className="bg-primary mx-auto mt-4 text-white h-[50px] text-[16px] font-normal">
        {t("View all Blogs")}{" "}
        <Image
          src="/icons/arrowWhite.png"
          alt="arrow"
          width={12}
          height={12}
        />
      </Button></Link>
    </div>
  );
}

export default RelatesBlogs