// 'use client'
// import Image from "next/image";
// import React, { useState } from "react";

// import {
//   Select,
//   SelectContent,
//   SelectGroup,
//   SelectItem,
//   SelectLabel,
//   SelectTrigger,
//   SelectValue,
// } from "@/components/ui/select";
// import { Input } from "@/components/ui/input";
// import { Textarea } from "@/components/ui/textarea";
// import { Button } from "@/components/ui/button";
// import { baseUrl } from "@/lib/config";

// const ContactInformation = () => {
//   const [firstName, setFirstName] = useState("");
//   const [lastName, setLastName] = useState("");
//   const [phone, setPhone] = useState("");
//   const [email, setEmail] = useState("");
//   const [inquiryType, setInquiryType] = useState("");
//   const [heardFrom, setHeardFrom] = useState("");
//   const [message, setMessage] = useState("");
//   const [agree, setAgree] = useState(false);

  
//   const handleSubmit = async (e) => {
//     e.preventDefault();

//     // if (!agree) {
//     //   alert("Please agree to the Terms of Use and Privacy Policy");
//     //   return;
//     // }

//     const payload = {
//       first_name: firstName,
//       last_name: lastName,
//       phone: phone,
//       email: email,
//       inquiry_type: inquiryType,
//       referral_source: heardFrom,
//       message: message,
//     };

//     try {
//       const res = await fetch(`${baseUrl}/api/contact-us-query`, {
//         method: "POST",
//         headers: { "Content-Type": "application/json" },
//         body: JSON.stringify(payload),
//       });

//       const data = await res.json();

//       if (!res.ok) {
//         console.error("Error:", data);
//         return;
//       }

//       console.log("Message sent successfully:", data);

//       setFirstName("");
//       setLastName("");
//       setPhone("");
//       setEmail("");
//       setInquiryType("");
//       setHeardFrom("");
//       setMessage("");
//       setAgree(false);
//     } catch (err) {
//       console.error("Request failed:", err);
//     }
//   };

//   const ContactInfo = [
//     {
//       icon: "/icons/contactpageIcons/Icon Container.png",
//       content: "info@sadurealestate.sa",
//     },
//     {
//       icon: "/icons/contactpageIcons/Icon Container (1).png",
//       content: "+966 XXXXXXXXX",
//     },
//     {
//       icon: "/icons/contactpageIcons/Icon Container (2).png",
//       content: "Sadu Real Estate,Saudi Arabia",
//     },
//     {
//       icon: "/icons/contactpageIcons/Icon Container (3).png",
//       content: "+966 XXXXXXXXX",
//     },
//     {
//       icon: "/icons/contactpageIcons/Icon Container (4).png",
//       content: "Sun-Thu:9:00 AM-6:00 PM ",
//       content2: "Fri-Sat:Closed/Appointment",
//     },
//   ];
//   return (
//     <div>
//       {/* Contact Information Cards */}
//       <div className="md:mt-10 pb-9 md:pb-[54px]">
//         <h1 className="text-primary font-semibold uppercase text-center sm:mb-3 md:pb-[15px]">
//           Contact
//         </h1>
//         <h1 className=" text-[30px] md:text-[35px] lg:text-[40px] font-semibold leading-tight  lg:mb-2 text-center">
//           <span className="text-primary"> Contact </span>Information
//         </h1>
//       </div>
//       <div className="grid  sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 gap-3 sm:gap-3  justify-items-center pb-[60px]">
//         {ContactInfo.map((item, index) => (
//           <div
//             key={index}
//             className="w-full bg-ligbg rounded-xl flex flex-col justify-between
//                  px-3 py-4 shadow-md sm:h-[180px] xl:h-[167px]"
//           >
//             <div className="flex flex-col items-center">
//               <Image src={item.icon} width={80} height={80} alt="bagicon" />
//             </div>
//             <div className="text-center space-y-1">
//               <p className=" text-sm md:text-xs font-semibold">
//                 {item.content}
//               </p>
//               {item.content2 && (
//                 <p className=" text-sm md:text-xs font-semibold">
//                   {item.content2}
//                 </p>
//               )}
//             </div>
//           </div>
//         ))}
//       </div>

//       {/* form// */}

//       <div>
//         {/* Contact Form */}
//         <div className="mt-4 sm:mt-6 ">
//           <h1 className="text-primary text-sm sm:text-base font-semibold uppercase text-center pb-[10px]">
//             Form
//           </h1>
//           <h1 className="text-primary text-[30px] md:text-[35px] lg:text-[40px] font-semibold mb-2 text-center">
//             Contact <span className="text-black">Form</span>
//           </h1>
//         </div>
//         <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-5 md:gap-6 lg:gap-7">
//           <div className="">
//             <label
//               htmlFor="firstname"
//               className="block text-sm sm:text-md font-medium text-gray-600 mb-3"
//             >
//               First Name
//             </label>

//             <Input
//               type="text"
//               required
//               value={firstName}
//               onChange={(e) => setFirstName(e.target.value)}
//               placeholder="Enter First Name"
//               className="bg-transparent border rounded-[12px]   text-[15px]"
//             />
//           </div>
//           <div className="">
//             <label
//               htmlFor="Phone"
//               className="block text-sm sm:text-md font-medium text-gray-600 mb-3"
//             >
//               Phone
//             </label>

//             <Input
//               type="number"
//               value={phone}
//               required
//               onChange={(e) => setPhone(e.target.value)}
//               placeholder="Enter Phone Number"
//               className="bg-transparent border rounded-[12px]  text-[15px]"
//             />
//           </div>

//           <div className="">
//             <label
//               htmlFor="lastname"
//               className="block text-sm sm:text-md font-medium text-gray-600 mb-3"
//             >
//               Last Name
//             </label>

//             <Input
//               type="text"
//               required
//               value={lastName}
//               onChange={(e) => setLastName(e.target.value)}
//               placeholder="Enter Last Name"
//               className="bg-transparent border rounded-[12px]  text-[15px]"
//             />
//           </div>
//           <div className="">
//             <label
//               htmlFor="inquiry"
//               className="block text-sm sm:text-md font-medium text-gray-600 mb-3"
//             >
//               Inquiry
//             </label>
//             <div className="relative w-full  mt-2">
//               <Select required className="" value={inquiryType} onValueChange={setInquiryType}>
//                 <SelectTrigger className="w-full rounded-[12px] md:h-[55px] lg:h-[55px]">
//                   <SelectValue
//                     className="rounded-[12px]"
//                     placeholder="Select Inquiry Type"
//                   />
//                 </SelectTrigger>
//                 <SelectContent className="bg-white shadow">
                  // <SelectGroup>
                  //   <SelectLabel>Select Inquiry Type</SelectLabel>
                  //   <SelectItem value="buying">Buying a Property</SelectItem>
                  //   <SelectItem value="renting">Renting a Property</SelectItem>
                  //   <SelectItem value="selling">Selling a Property</SelectItem>
                  //   <SelectItem value="listing">List My Property</SelectItem>
                  //   <SelectItem value="visit">
                  //     Schedule a Property Visit
                  //   </SelectItem>
                  //   <SelectItem value="info">
                  //     Request More Information
                  //   </SelectItem>
                  //   <SelectItem value="finance">
                  //     Mortgage / Financing Assistance
                  //   </SelectItem>
                  //   <SelectItem value="agent">Talk to an Agent</SelectItem>
                  //   <SelectItem value="investment">
                  //     Investment Opportunities
                  //   </SelectItem>
                  //   <SelectItem value="commercial">
                  //     Commercial Property Inquiry
                  //   </SelectItem>
                  //   <SelectItem value="residential">
                  //     Residential Property Inquiry
                  //   </SelectItem>
                  //   <SelectItem value="partnership">
                  //     Partnership / Collaboration
                  //   </SelectItem>
                  //   <SelectItem value="support">
                  //     Support / Technical Help
                  //   </SelectItem>
                  //   <SelectItem value="general">General Inquiry</SelectItem>
                  // </SelectGroup>
//                 </SelectContent>
//               </Select>
//               <span className="absolute right-3 top-1/2 -translate-y-1/2 text-gray-500 pointer-events-none">
//                 {/* <IoIosArrowDown /> */}
//               </span>
//             </div>
//           </div>

//           <div className="">
//             <label
//               htmlFor="email"
//               className="block text-sm sm:text-md font-medium text-gray-600 mb-3"
//             >
//               Email
//             </label>

//             <Input
//           type="email"
//           required
//         value={email}
//         onChange={(e) => setEmail(e.target.value)}
//               placeholder="Enter Email"
//               className="bg-transparent border  rounded-[12px] text-[15px]"
//             />
//           </div>
//           <div className="">
//             <label
//               htmlFor="inquiry"
//               className="block text-sm sm:text-md font-medium text-gray-600 mb-3"
//             >
//               How Did You Hear About Us?
//             </label>
//             <div className="relative w-full  mt-2">
//               <Select required value={heardFrom} onValueChange={setHeardFrom}>
//                 <SelectTrigger className="w-full rounded-[12px] md:h-[55px] lg:h-[55px]">
//                   <SelectValue
//                     className="rounded-[12px]"
//                     placeholder="Select"
//                   />
//                 </SelectTrigger>
//                 <SelectContent className="bg-white shadow">
//                   <SelectGroup>
//                     <SelectLabel>How did you hear about us?</SelectLabel>
//                     <SelectItem value="google_search">Google Search</SelectItem>
//                     <SelectItem value="facebook">Facebook</SelectItem>
//                     <SelectItem value="instagram">Instagram</SelectItem>
//                     <SelectItem value="tiktok">TikTok</SelectItem>
//                     <SelectItem value="youtube">YouTube</SelectItem>
//                     <SelectItem value="linkedin">LinkedIn</SelectItem>
//                     <SelectItem value="whatsapp">WhatsApp</SelectItem>
//                     <SelectItem value="google_ads">Google Ads</SelectItem>
//                     <SelectItem value="facebook_ads">
//                       Facebook / Instagram Ads
//                     </SelectItem>
//                     <SelectItem value="real_estate_portal">
//                       Real Estate Portal
//                     </SelectItem>
//                     <SelectItem value="email">Email Newsletter</SelectItem>
//                     <SelectItem value="sms">SMS Campaign</SelectItem>
//                     <SelectItem value="blog">Online Article / Blog</SelectItem>
//                     <SelectItem value="referral">
//                       Friend or Family Referral
//                     </SelectItem>
//                     <SelectItem value="agent">Real Estate Agent</SelectItem>
//                     <SelectItem value="billboard">
//                       Billboard / Outdoor Ad
//                     </SelectItem>
//                     <SelectItem value="tv_radio">TV / Radio</SelectItem>
//                     <SelectItem value="event">
//                       Event / Expo / Open House
//                     </SelectItem>
//                     <SelectItem value="flyer">Flyer / Brochure</SelectItem>
//                     <SelectItem value="office">Visited Your Office</SelectItem>
//                     <SelectItem value="other">Other</SelectItem>
//                   </SelectGroup>
//                 </SelectContent>
//               </Select>
//               <span className="absolute right-3 top-1/2 -translate-y-1/2 text-gray-500 pointer-events-none">
//                 {/* <IoIosArrowDown /> */}
//               </span>
//             </div>
//           </div>
//         </div>
//         {/* Message Textarea */}
//         <div className=" md:mt-6 pb-[10px]">
//           <label
//             htmlFor="message"
//             className="block text-sm sm:text-md font-medium text-gray-600 mb-3"
//           >
//             Message
//           </label>
//           {/* <textarea
//           id="message"
//           name="message"
//           placeholder="Enter your message here"
//           className="w-full border border-gray-500 rounded-xl p-3 mt-2 placeholder:text-gray-500 placeholder:font-light text-sm sm:text-base"
//           rows={4}
//         /> */}
//           <Textarea
//               value={message}
//               required
//         onChange={(e) => setMessage(e.target.value)}
//             placeholder="Enter your message here"
//             className="min-h-[120px] rounded-[12px]"
//           />
//         </div>
//         {/* Form Footer */}
//         <div className="flex flex-col sm:flex-row justify-between items-start sm:items-center mt-5 gap-4 pb-10 lg:pb-[70px]">
//           <div className="flex items-center space-x-2">
//             <input
//              type="checkbox"
//              required
//           checked={agree}
//           onChange={(e) => setAgree(e.target.checked)}
//               className="w-4 h-4 sm:w-5 sm:h-5 text-primary border-gray-300 rounded"
//             />
//             <label htmlFor="agree" className="text-xs sm:text-sm text-gray-600">
//               I agree to the <span className="underline">Terms of Use</span> and{" "}
//               <span className="underline">Privacy Policy</span>
//             </label>
//           </div>
//           <Button className="bg-primary " onClick={handleSubmit}>Send Your Message</Button>
//         </div>
//       </div>
//     </div>
//   );
// };

// export default ContactInformation;


'use client';
import Image from "next/image";
import React, { useState } from "react";

import {
  Select,
  SelectContent,
  SelectGroup,
  SelectItem,
  SelectLabel,
  SelectTrigger,
  SelectValue,
} from "@/components/ui/select";
import { Input } from "@/components/ui/input";
import { Textarea } from "@/components/ui/textarea";
import { Button } from "@/components/ui/button";
import { baseUrl } from "@/lib/config";
import { useTranslation } from "react-i18next";

const ContactInformation = () => {
  const { t } = useTranslation("contact");
  const [formData, setFormData] = useState({
    firstName: "",
    lastName: "",
    phone: "",
    email: "",
    inquiryType: "",
    heardFrom: "",
    message: "",
    agree: false,
  });

  const [touched, setTouched] = useState({});
  const [errors, setErrors] = useState({});
  const [apiErrors, setApiErrors] = useState({});
  const [isSubmitting, setIsSubmitting] = useState(false);

  // Validation function
  const validate = (data) => {
    const newErrors = {};

    if (!data.firstName.trim()) newErrors.firstName = "First name is required";
    if (!data.lastName.trim()) newErrors.lastName = "Last name is required";
    if (!data.phone.trim()) newErrors.phone = "Phone number is required";
    else if (!/^\d+$/.test(data.phone)) newErrors.phone = "Phone must contain only numbers";
    if (!data.email.trim()) newErrors.email = "Email is required";
    else if (!/\S+@\S+\.\S+/.test(data.email)) newErrors.email = "Invalid email address";
    if (!data.inquiryType) newErrors.inquiryType = "Please select an inquiry type";
    if (!data.heardFrom) newErrors.heardFrom = "Please select how you heard about us";
    if (!data.message.trim()) newErrors.message = "Message is required";
    if (!data.agree) newErrors.agree = "You must agree to the Terms and Privacy Policy";

    return newErrors;
  };

  const handleBlur = (field) => {
    setTouched((prev) => ({ ...prev, [field]: true }));
    setErrors(validate(formData));
  };

  const handleChange = (field, value) => {
    setFormData((prev) => ({ ...prev, [field]: value }));
    if (touched[field]) {
      setErrors(validate({ ...formData, [field]: value }));
    }
  };

  const isFormValid = Object.keys(validate(formData)).length === 0;

  const handleSubmit = async (e) => {
    e.preventDefault();
    setTouched({
      firstName: true,
      lastName: true,
      phone: true,
      email: true,
      inquiryType: true,
      heardFrom: true,
      message: true,
      agree: true,
    });

    const validationErrors = validate(formData);
    setErrors(validationErrors);
    setApiErrors({});

    if (Object.keys(validationErrors).length > 0) return;

    setIsSubmitting(true);
    try {
      const res = await fetch(`${baseUrl}/api/contact-us-query`, {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({
          first_name: formData.firstName,
          last_name: formData.lastName,
          phone: formData.phone,
          email: formData.email,
          inquiry_type: formData.inquiryType,
          referral_source: formData.heardFrom,
          message: formData.message,
        }),
      });

      const data = await res.json();

      if (!res.ok) {
        if (data.errors) setApiErrors(data.errors);
        return;
      }

      // Reset form
      setFormData({
        firstName: "",
        lastName: "",
        phone: "",
        email: "",
        inquiryType: "",
        heardFrom: "",
        message: "",
        agree: false,
      });
      setTouched({});
      setErrors({});
    } catch (err) {
      console.error("Request failed:", err);
    } finally {
      setIsSubmitting(false);
    }
  };

  const ContactInfo = [
    { icon: "/icons/contactpageIcons/Icon Container.png", content: "info@sadurealestate.sa" },
    { icon: "/icons/contactpageIcons/Icon Container (1).png", content: "+966 XXXXXXXXX" },
    { icon: "/icons/contactpageIcons/Icon Container (2).png", content: t("adress") },
    { icon: "/icons/contactpageIcons/Icon Container (3).png", content: "+966 XXXXXXXXX" },
    { icon: "/icons/contactpageIcons/Icon Container (4).png", content: t("Sun-Thu:9:00 AM-6:00 PM"), content2: t("Fri-Sat:Closed/Appointment") },
  ];

  return (
    <div>
      {/* Contact Info Cards */}
      <div className="md:mt-10 pb-9 md:pb-[54px]">
        <h1 className="text-primary font-semibold uppercase text-center sm:mb-3 md:pb-[15px]">{t("Contact")}</h1>
        <h1 className=" text-[30px] md:text-[35px] lg:text-[40px] font-semibold leading-tight  lg:mb-2 text-center">
          <span className="text-primary"> {t("Contact")} </span>{t("Information")}
        </h1>
      </div>
      <div className="grid sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 gap-3 justify-items-center pb-[60px]">
        {ContactInfo.map((item, index) => (
          <div key={index} className="w-full bg-ligbg rounded-xl px-3 py-4 shadow-md sm:h-[180px] xl:h-[167px]">
            <div className="flex flex-col items-center">
              <Image src={item.icon} width={80} height={80} alt="icon" />
            </div>
            <div className="text-center space-y-1">
              <p className="text-sm md:text-xs font-semibold">{item.content}</p>
              {item.content2 && <p className="text-sm md:text-xs font-semibold">{item.content2}</p>}
            </div>
          </div>
        ))}
      </div>

      {/* Contact Form */}
      <form onSubmit={handleSubmit}>
        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-5 md:gap-6 lg:gap-7">
          {/* First Name */}
          <div>
            <label className="block text-sm font-medium text-gray-600 mb-3">{t("First Name")}</label>
            <Input
              type="text"
              value={formData.firstName}
              onChange={(e) => handleChange("firstName", e.target.value)}
              onBlur={() => handleBlur("firstName")}
              placeholder={t("Enter First Name")}
              className="bg-transparent border rounded-[12px] text-[15px]"
            />
            {touched.firstName && errors.firstName && <p className="text-red-500 text-sm">{errors.firstName}</p>}
            {apiErrors.firstName && <p className="text-red-500 text-sm">{apiErrors.firstName}</p>}
          </div>

          {/* Phone */}
          <div>
            <label className="block text-sm font-medium text-gray-600 mb-3">{t("Phone")}</label>
            <Input
              type="text"
              value={formData.phone}
              onChange={(e) => handleChange("phone", e.target.value)}
              onBlur={() => handleBlur("phone")}
              placeholder={t("Enter Phone Number")}
              className="bg-transparent border rounded-[12px] text-[15px]"
            />
            {touched.phone && errors.phone && <p className="text-red-500 text-sm">{errors.phone}</p>}
            {apiErrors.phone && <p className="text-red-500 text-sm">{apiErrors.phone}</p>}
          </div>

          {/* Last Name */}
          <div>
            <label className="block text-sm font-medium text-gray-600 mb-3">{t("Last Name")}</label>
            <Input
              type="text"
              value={formData.lastName}
              onChange={(e) => handleChange("lastName", e.target.value)}
              onBlur={() => handleBlur("lastName")}
              placeholder={t("Enter Last Name")}
              className="bg-transparent border rounded-[12px] text-[15px]"
            />
            {touched.lastName && errors.lastName && <p className="text-red-500 text-sm">{errors.lastName}</p>}
            {apiErrors.lastName && <p className="text-red-500 text-sm">{apiErrors.lastName}</p>}
          </div>

          {/* Inquiry Type */}
          <div>
            <label className="block text-sm font-medium text-gray-600 mb-3">{t("Inquiry")}</label>
            {/* <Select
              value={formData.inquiryType}
              onValueChange={(val) => handleChange("inquiryType", val)}
              onBlur={() => handleBlur("inquiryType")}
            >
              <SelectTrigger className="w-full rounded-[12px] md:h-[55px]">
                <SelectValue placeholder={t("Select Inquiry Type")} />
              </SelectTrigger>
              <SelectContent className="bg-white shadow">
              <SelectGroup className='max-h-[300px] overflow-y-auto'>
                    <SelectLabel>{t("Select Inquiry Type")}</SelectLabel>
                    <SelectItem value="buying">{("Buying a Property")}</SelectItem>
                    <SelectItem value="renting">Renting a Property</SelectItem>
                    <SelectItem value="selling">Selling a Property</SelectItem>
                    <SelectItem value="listing">List My Property</SelectItem>
                    <SelectItem value="visit">
                      Schedule a Property Visit
                    </SelectItem>
                    <SelectItem value="info">
                      Request More Information
                    </SelectItem>
                    <SelectItem value="finance">
                      Mortgage / Financing Assistance
                    </SelectItem>
                    <SelectItem value="agent">Talk to an Agent</SelectItem>
                    <SelectItem value="investment">
                      Investment Opportunities
                    </SelectItem>
                    <SelectItem value="commercial">
                      Commercial Property Inquiry
                    </SelectItem>
                    <SelectItem value="residential">
                      Residential Property Inquiry
                    </SelectItem>
                    <SelectItem value="partnership">
                      Partnership / Collaboration
                    </SelectItem>
                    <SelectItem value="support">
                      Support / Technical Help
                    </SelectItem>
                    <SelectItem value="general">General Inquiry</SelectItem>
                  </SelectGroup>
              </SelectContent>
            </Select> */}
            <Select
  value={formData.inquiryType}
  onValueChange={(val) => handleChange("inquiryType", val)}
  onBlur={() => handleBlur("inquiryType")}
>
  <SelectTrigger className="w-full rounded-[12px] md:h-[55px]">
    <SelectValue placeholder={t("Select Inquiry Type")} />
  </SelectTrigger>

  <SelectContent className="bg-white shadow">
    <SelectGroup className="max-h-[300px] overflow-y-auto">
      <SelectLabel>{t("Select Inquiry Type")}</SelectLabel>

      <SelectItem value="buying">{t("Buying a Property")}</SelectItem>
      <SelectItem value="renting">{t("Renting a Property")}</SelectItem>
      <SelectItem value="selling">{t("Selling a Property")}</SelectItem>
      <SelectItem value="listing">{t("List My Property")}</SelectItem>
      <SelectItem value="visit">{t("Schedule a Property Visit")}</SelectItem>
      <SelectItem value="info">{t("Request More Information")}</SelectItem>
      <SelectItem value="finance">{t("Mortgage / Financing Assistance")}</SelectItem>
      <SelectItem value="agent">{t("Talk to an Agent")}</SelectItem>
      <SelectItem value="investment">{t("Investment Opportunities")}</SelectItem>
      <SelectItem value="commercial">{t("Commercial Property Inquiry")}</SelectItem>
      <SelectItem value="residential">{t("Residential Property Inquiry")}</SelectItem>
      <SelectItem value="partnership">{t("Partnership / Collaboration")}</SelectItem>
      <SelectItem value="support">{t("Support / Technical Help")}</SelectItem>
      <SelectItem value="general">{t("General Inquiry")}</SelectItem>
    </SelectGroup>
  </SelectContent>
</Select>

            {touched.inquiryType && errors.inquiryType && <p className="text-red-500 text-sm">{errors.inquiryType}</p>}
            {apiErrors.inquiryType && <p className="text-red-500 text-sm">{apiErrors.inquiryType}</p>}
          </div>

          {/* Email */}
          <div>
            <label className="block text-sm font-medium text-gray-600 mb-3">{t("Email")}</label>
            <Input
              type="email"
              value={formData.email}
              onChange={(e) => handleChange("email", e.target.value)}
              onBlur={() => handleBlur("email")}
              placeholder={t("Enter Email")}
              className="bg-transparent border rounded-[12px] text-[15px]"
            />
            {touched.email && errors.email && <p className="text-red-500 text-sm">{errors.email}</p>}
            {apiErrors.email && <p className="text-red-500 text-sm">{apiErrors.email}</p>}
          </div>

          {/* Heard From */}
          <div>
            <label className="block text-sm font-medium text-gray-600 mb-3">{t("How Did You Hear About Us?")}</label>
            {/* <Select
              value={formData.heardFrom}
              onValueChange={(val) => handleChange("heardFrom", val)}
              onBlur={() => handleBlur("heardFrom")}
            >
              <SelectTrigger className="w-full rounded-[12px] md:h-[55px]">
                <SelectValue placeholder="Select" />
              </SelectTrigger>
              <SelectContent className="bg-white shadow">
                 <SelectGroup className='max-h-[300px] overflow-y-auto'>
                     <SelectLabel>{t("How did you hear about us?")}</SelectLabel>
                     <SelectItem value="google_search">Google Search</SelectItem>
                     <SelectItem value="facebook">Facebook</SelectItem>
                     <SelectItem value="instagram">Instagram</SelectItem>
                     <SelectItem value="tiktok">TikTok</SelectItem>
                     <SelectItem value="youtube">YouTube</SelectItem>
                     <SelectItem value="linkedin">LinkedIn</SelectItem>
                     <SelectItem value="whatsapp">WhatsApp</SelectItem>
                     <SelectItem value="google_ads">Google Ads</SelectItem>
                     <SelectItem value="facebook_ads">
                       Facebook / Instagram Ads
                     </SelectItem>
                     <SelectItem value="real_estate_portal">
                       Real Estate Portal
                     </SelectItem>
                     <SelectItem value="email">Email Newsletter</SelectItem>
                     <SelectItem value="sms">SMS Campaign</SelectItem>
                     <SelectItem value="blog">Online Article / Blog</SelectItem>
                     <SelectItem value="referral">
                       Friend or Family Referral
                     </SelectItem>
                     <SelectItem value="agent">Real Estate Agent</SelectItem>
                     <SelectItem value="billboard">
                       Billboard / Outdoor Ad
                     </SelectItem>
                     <SelectItem value="tv_radio">TV / Radio</SelectItem>
                     <SelectItem value="event">
                       Event / Expo / Open House
                     </SelectItem>
                     <SelectItem value="flyer">Flyer / Brochure</SelectItem>
                     <SelectItem value="office">Visited Your Office</SelectItem>
                     <SelectItem value="other">Other</SelectItem>
                   </SelectGroup>
              </SelectContent>
            </Select> */}
            <Select
  value={formData.heardFrom}
  onValueChange={(val) => handleChange("heardFrom", val)}
  onBlur={() => handleBlur("heardFrom")}
>
  <SelectTrigger className="w-full rounded-[12px] md:h-[55px]">
    <SelectValue placeholder={t("Select")} />
  </SelectTrigger>

  <SelectContent className="bg-white shadow">
    <SelectGroup className="max-h-[300px] overflow-y-auto">
      <SelectLabel>{t("How did you hear about us?")}</SelectLabel>

      <SelectItem value="google_search">{t("Google Search")}</SelectItem>
      <SelectItem value="facebook">{t("Facebook")}</SelectItem>
      <SelectItem value="instagram">{t("Instagram")}</SelectItem>
      <SelectItem value="tiktok">{t("TikTok")}</SelectItem>
      <SelectItem value="youtube">{t("YouTube")}</SelectItem>
      <SelectItem value="linkedin">{t("LinkedIn")}</SelectItem>
      <SelectItem value="whatsapp">{t("WhatsApp")}</SelectItem>
      <SelectItem value="google_ads">{t("Google Ads")}</SelectItem>
      <SelectItem value="facebook_ads">
        {t("Facebook / Instagram Ads")}
      </SelectItem>
      <SelectItem value="real_estate_portal">{t("Real Estate Portal")}</SelectItem>
      <SelectItem value="email">{t("Email Newsletter")}</SelectItem>
      <SelectItem value="sms">{t("SMS Campaign")}</SelectItem>
      <SelectItem value="blog">{t("Online Article / Blog")}</SelectItem>
      <SelectItem value="referral">{t("Friend or Family Referral")}</SelectItem>
      <SelectItem value="agent">{t("Real Estate Agent")}</SelectItem>
      <SelectItem value="billboard">{t("Billboard / Outdoor Ad")}</SelectItem>
      <SelectItem value="tv_radio">{t("TV / Radio")}</SelectItem>
      <SelectItem value="event">{t("Event / Expo / Open House")}</SelectItem>
      <SelectItem value="flyer">{t("Flyer / Brochure")}</SelectItem>
      <SelectItem value="office">{t("Visited Your Office")}</SelectItem>
      <SelectItem value="other">{t("Other")}</SelectItem>
    </SelectGroup>
  </SelectContent>
</Select>

            {touched.heardFrom && errors.heardFrom && <p className="text-red-500 text-sm">{errors.heardFrom}</p>}
            {apiErrors.heardFrom && <p className="text-red-500 text-sm">{apiErrors.heardFrom}</p>}
          </div>
        </div>

        {/* Message */}
        <div className="md:mt-6 pb-[10px]">
          <label className="block text-sm font-medium text-gray-600 mb-3">{t("Message")}</label>
          <Textarea
            value={formData.message}
            onChange={(e) => handleChange("message", e.target.value)}
            onBlur={() => handleBlur("message")}
            placeholder={t("Enter your message here")}
            className="min-h-[120px] rounded-[12px]"
          />
          {touched.message && errors.message && <p className="text-red-500 text-sm">{errors.message}</p>}
          {apiErrors.message && <p className="text-red-500 text-sm">{apiErrors.message}</p>}
        </div>

        {/* Footer */}
        <div className="flex flex-col sm:flex-row justify-between items-start sm:items-center mt-5 gap-4 pb-10">
          <div className="flex items-center space-x-2">
            <input
              type="checkbox"
              checked={formData.agree}
              onChange={(e) => handleChange("agree", e.target.checked)}
              onBlur={() => handleBlur("agree")}
              className="w-4 h-4 sm:w-5 sm:h-5 text-primary border-gray-300 rounded"
            />
            <label className="text-xs sm:text-sm text-gray-600">
             {t("I agree to the")} <span className="underline">{t("Terms of Use")}</span> {t("and")}{" "}
              <span className="underline">{t("Privacy Policy")}</span>
            </label>
          </div>
          {touched.agree && errors.agree && <p className="text-red-500 text-sm">{errors.agree}</p>}
          <Button type="submit" className="bg-primary" disabled={!isFormValid || isSubmitting}>
            {isSubmitting ? t("Sending...") : t("Send Your Message")}
          </Button>
        </div>
      </form>
    </div>
  );
};

export default ContactInformation;
