'use client'
import Image from 'next/image';
import React from 'react'
import { useTranslation } from 'react-i18next';

const OfficeLocation = () => {
    const { t } = useTranslation("contact");
  
     const LocationsData = [
    {
      title1: t("Main Office"),
      title2: t("Main Office add"),
      para: t("maindesc"),
      tag1: "info@sadurealestate.sa",
      tag2: "+966 XXXXXXXX",
      tag3: "Riyadh",
      tag4: t("Get Direction"),
    },
    {
      title1: t("Second Office"),
      title2: t("secondadd"),
      para: t("seconddesc"),
      tag1: "info@sadurealestate.sa",
      tag2: "+966 XXXXXXXX",
      tag3: "Jeddah",
      tag4: t("Get Direction"),
    },
  ];
   const ContactData = [
    {
        icon: '/icons/contactpageIcons/Vector (11).png',
    },
    {
        icon: '/icons/contactpageIcons/Vector (12).png',
    },
    {
        icon: '/icons/contactpageIcons/Vector (13).png',
    },
    {
        icon: '/icons/contactpageIcons/Vector (14).png',
    },
    {
        icon: '/icons/contactpageIcons/Vector (15).png',
    },
  
  ];
  return (
    <>
    <div className='px-5 md:px-[50px] lg:px-[96px]'>
      {/* Office Locations heading */}
      <div className="mt-8 sm:mt-10 text-center">
        <h1 className="text-primary font-semibold pb-3 ">
          {t("Location")}
        </h1>
        
         <h2 className="text-[30px] md:text-[35px] lg:text-[40px] font-semibold mb-0">
        {t("Offices")} <span className="text-primary">{t("Location")}</span>
      </h2>
      </div>
      {/* Office contact portion */}
      <div className="grid grid-cols-1 lg:grid-cols-2 gap-y-5 sm:gap-6 mt-4 sm:mt-5 pb-10 md:pb-[70px]">
        {LocationsData.map((loc, index) => (
          <div
            key={index}
            className="w-full h-auto p-6 sm:p-6 md:p-8 lg:p-5 xl:p-10 bg-ligbg rounded-xl"
          >
            {/* Titles */}
            <h1 className="font-medium text-sm sm:text-base">{loc.title1}</h1>
            <h1 className="font-semibold text-xl sm:text-2xl pt-2 sm:pt-3">
              {loc.title2}
            </h1>
            {/* Description */}
            <p className=" text-xs sm:text-sm md:text-base leading-relaxed pt-2 sm:pt-3">
              {loc.para}
            </p>
            <div className="flex flex-col md:flex-row md:flex-wrap gap-1 mt-4">
              {/* Tag 1 */}
              <div className="flex items-center justify-center gap-1 text-white bg-primary rounded-xl w-full md:w-[49%] lg:w-[44%] h-[35px]">
                 <Image src='/icons/contactpageIcons/Subtract.png' width={18} height={14} alt='bagicon' />
                <span className="font-medium text-[clamp(12px,2vw,14px)] lg:text-[clamp(7px,1vw,10.5px)] whitespace-nowrap overflow-hidden">
                  {loc.tag1}
                </span>
              </div>
              {/* Tag 2 */}
              <div className="flex items-center justify-center gap-1 text-white bg-primary rounded-xl w-full md:w-[49%] lg:w-[35%] h-[35px]">
                  <Image src='/icons/contactpageIcons/Vector (Stroke).png' width={18} height={18} alt='bagicon' />
                <span className="font-medium text-[clamp(12px,2vw,14px)] lg:text-[clamp(7px,1vw,14px)] whitespace-nowrap overflow-hidden">
                  {loc.tag2}
                </span>
              </div>
              {/* Tag 3 */}
              <div className="flex items-center justify-center gap-1 text-white bg-primary rounded-xl w-full md:w-[99%] lg:w-[18%] h-[35px]">
                   <Image src='/icons/contactpageIcons/Subtract (1).png' width={14} height={17} alt='bagicon' />
                <span className="font-medium text-[clamp(12px,2vw,14px)] lg:text-[clamp(7px,1vw,14px)] whitespace-nowrap overflow-hidden">
                  {loc.tag3}
                </span>
              </div>
              {/* CTA Button */}
              <div className="w-full h-[46px] bg-primary rounded-xl mt-3 md:mt-4 text-white flex items-center justify-center font-medium text-sm sm:text-base cursor-pointer">
                <span>{loc.tag4}</span>
              </div>
            </div>
          </div>
        ))}
      </div>
    </div>

    <div className="pb-[61px]">
      {/* Social Media Channels */}
      <div className="pb-8 md:pb-[43px] text-center">
        {/* <h1 className="text-primary text-sm sm:text-base font-semibold uppercase text-center pb-[5px]">
          Social Media
        </h1>
        <h1 className=" text-3xl sm:text-4xl md:text-5xl font-semibold leading-tight sm:leading-[75px] mb-1 text-center ">
          Additional <span className="text-primary">Contact</span> Channels
        </h1> */}
         <h1 className="text-primary font-semibold pb-3 ">
            {t("Social Media")}
        </h1>
        
         <h2 className="text-[30px] md:text-[35px] lg:text-[40px] font-semibold mb-0">
          {t("Additional Contact Channels")}
      </h2>
        <p className=" text-xs sm:text-sm md:text-base leading-relaxed text-center">
          {t("Follow us for latest property updates and news.")}
        </p>
      </div>
      <div className="flex w-full h-auto bg-primary py-7 px-5 md:py-10">
        <div className="flex flex-wrap justify-center items-center gap-6  mx-auto">
          {ContactData.map((data, idx) => (
            <div
              key={idx}
              className="w-[60px] h-[60px] md:w-[80px] md:h-[80px] lg:w-[100px] lg:h-[100px] rounded-full border-2 border-white bg-primary flex justify-center items-center"
            >
              <Image src={data.icon} width={26} height={24} alt='bagicon' />
            </div>
          ))}
        </div>
      </div>
    </div>
    </>
  )
}

export default OfficeLocation