'use client';

import { motion } from 'framer-motion';
import Image from 'next/image';
import React, { useEffect, useState } from 'react';

const logos = [
  '/icons/brand-logos/image 27.png',
  '/icons/brand-logos/image 28.png',
  '/icons/brand-logos/image 29.png',
  '/icons/brand-logos/image 30.png',
  '/icons/brand-logos/image 27.png',
  '/icons/brand-logos/image 28.png',
  '/icons/brand-logos/image 29.png',
  '/icons/brand-logos/image 30.png',
];

const BrandMarquee = () => {
  const [isRTL, setIsRTL] = useState(false);

  useEffect(() => {
    if (typeof document !== 'undefined') {
      // Initial direction check
      setIsRTL(document.documentElement.dir === 'rtl');

      // Observe direction changes (when lang is switched)
      const observer = new MutationObserver(() => {
        setIsRTL(document.documentElement.dir === 'rtl');
      });

      observer.observe(document.documentElement, { attributes: true, attributeFilter: ['dir'] });

      // Cleanup observer when component unmounts
      return () => observer.disconnect();
    }
  }, []);

  return (
    <div className="overflow-hidden bg-secordary py-5 mb-1">
      <motion.div
        className="flex gap-[60px] w-max"
        initial={{ x: '0%' }}
        animate={{ x: isRTL ? '50%' : '-50%' }}
        transition={{ ease: 'linear', repeat: Infinity, duration: 15 }}
        key={isRTL ? 'rtl' : 'ltr'} // Force restart animation on direction change
      >
        {[...logos, ...logos].map((src, index) => (
          <Image
            key={index}
            src={src}
            alt={`Brand logo ${index}`}
            width={100}
            height={60}
            className="rounded-xl object-contain"
          />
        ))}
      </motion.div>
    </div>
  );
};

export default BrandMarquee;
