"use client"
import { Card, CardContent, CardTitle } from '@/components/ui/card';
import Link from 'next/link';
import React from 'react'
import { useTranslation } from 'react-i18next';

export const ServicesPageMainContent = () => {
          const { t } = useTranslation("services");
    
    const servicesData = [
  {
    id: 1,
    slug: "/service/buying-and-selling",
    title: "BUYING & SELLING PROPERTIES",
    highlight: "Real Estate",
    preHighlight: "Your Trusted Partner in ",
    postHighlight: "Transactions",
    description:
      "Whether you’re looking to buy your dream home, invest in a promising property, or sell your existing asset, our comprehensive buying and selling services cover every step of the process with professionalism and personalized care.",
    buttonText: "View details",
    icon: "/assets/ServicesIcon/angle-right.png",
  },
  {
    id: 2,
    slug: "/service/rentals-and-management",
    title: "PROPERTY RENTAL & MANAGEMENT",
    highlight: "Investment Returns",
    preHighlight: "Simplifying Rentals and Maximizing ",
    postHighlight: "",
    description:
      "Navigating the rental market can be challenging for both tenants and landlords. We provide comprehensive rental services to connect tenants with ideal properties and support landlords in managing their investments efficiently and profitably.",
    buttonText: "View details",
    icon: "/assets/ServicesIcon/angle-right.png",
  },
  {
    id: 3,
    slug: "/service/valuation-and-Advisory",
    title: "PROPERTY VALUTATION & ADVISORY",
    highlight: "Real Estate",
    preHighlight: "Expert Valuations and Strategic   ",
    postHighlight: "Guidance",
    description:
      "Making smart property decisions starts with knowing the true value of your asset. Our professional valuation and advisory services equip you with precise, data-driven insights to maximize returns and minimize risks",
    buttonText: "View details",
    icon: "/assets/ServicesIcon/angle-right.png",
  },
  {
    id: 4,
    slug: "/service/luxury-properties",
    title: "LUXURY & INVESTMENT PROPERTIES",
    highlight: "Real Estate",
    preHighlight: "Exclusive Access to Premium ",
    postHighlight: " Opportunities   ",
    description:
      "Our expertise lies in the luxury and investment property market, connecting discerning buyers and investors with exceptional real estate that combines elegance, exclusivity, and strong financial potential.",
    buttonText: "View details",
    icon: "/assets/ServicesIcon/angle-right.png",
  },
  {
    id: 5,
    slug: "/service/new-developments",
    title: "OFF PLAN & NEW DEVELOPEMENT SALES",
    highlight: "New Projects",
    preHighlight: "Get Early Access to Jeddah’s Most Exciting  ",
    postHighlight: "",
    description:
      "Stay ahead of the market with our exclusive partnerships with top developers, offering you a first look at the latest off-plan properties and new developments shaping Jeddah’s real estate future.",
    buttonText: "View details",
    icon: "/assets/ServicesIcon/angle-right.png",
  },
  {
    id: 6,
    slug: "/service/hoa-and-facility-management",
    title: "HOA & FACILITY MANAGEMENT",
    highlight: "Property Care",
    preHighlight: "Ensuring Operational Excellence in ",
    postHighlight: "Communities",
    description:
      "We provide professional homeowners association and facility management services to maintain, operate, and enhance residential and commercial properties, ensuring long-term value and tenant satisfaction.",
    buttonText: "View details",
    icon: "/assets/ServicesIcon/angle-right.png",
  },
];

  return (
    <div className="px-5 md:px-[50px] lg:px-[96px] bg-ligbg py-8 lg:py-12 text-center">
          <h1 className=" text-primary mb-2 font-semibold">{t("SERVICES")}</h1>
          <h2 className="text-[30px]  md:text-[35px] lg:text-[40px] font-semibold mb-6">
            {t("Explore Our Services")}
          </h2>
          <div className="grid sm:grid-cols-2 md:grid-cols-3 gap-6 md:gap-4 lg:gap-6 ">
            {servicesData?.map((service, index) => (

              <Card
                key={index}
                className="service-type-card transition-all justify-between text-center border-b-0 border-r-0 border-l-0 shadow-none gap-3 lg:gap-[18px] px-4 lg:px-6 pt-6 lg:pt-8 pb-6 border-t-10 border-primary rounded-sm hover:bg-primary hover:text-white"
              >
                <div>
                <CardTitle className="text-[18px] lg:text-[20px] font-bold text-primary hover:text-white service-type-name">
                  {service?.title}
                </CardTitle>

                <CardContent className="px-0 pt-3">
                  <p className="text-center px-0 text-[14px]">
                    {service.description}
                  </p>
                </CardContent>
                </div>
                <Link
                  href={service?.slug}
                  className="flex items-center gap-2 text-center justify-center font-semibold"
                >
                  {t("Learn More")}{" "}
                  {/* <Image
                    src="/icons/arrowWhite.png"
                    alt="arrow"
                    width={12}
                    height={12}
                  /> */}
                </Link>
              </Card>
            ))}
          </div>
        </div>
  )
}
