import Image from "next/image";
import { Button } from "@/components/ui/button";
import Footer from "./components/Footer";
import Link from "next/link";
import { Card, CardContent, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import Navbar from "./components/Navbar/Navbar";
import BrandMarquee from "./components/marquee/BrandMarquee";
import { PropertyListings } from "./components/PropertyListings";
import WhatSetsAsApart from "./components/WhatSetsAsApart";
import { ClientTestimonials } from "./components/ClientTestimonials";
import BlogInHome from "./components/blogComponents/BlogInHome";
import HeroSection from "./components/HeroSection";
import AboutSection from "./components/AboutSection";
import ServicesSection from "./components/ServicesSection";
import { baseUrl } from "@/lib/config";
import { cookies } from "next/headers";
async function getData() {
    const cookieStore = await cookies(); // ✅ Await cookies()

    const token = cookieStore.get("sadu_auth_token")?.value;
  
  const [
    blogData,
    propertyData
   
  ] = await Promise.all([
    fetch(`${baseUrl}/api/blogs`, { cache: "no-store" }).then(res => res.json()),
    fetch(`${baseUrl}/api/properties`, {
      cache: "no-store",
      headers: {
        Authorization: `Bearer ${token}`,
      },
    }).then((res) => res.json()),

  ]);

  return { blogData, propertyData };
}
export default async  function Home() {
 const {
    blogData,
   propertyData
  } = await getData();

  return (
    <div className="">
      <Navbar />
      <main className="">
        {/* Hero Section */}
        <HeroSection
          head="HOME"
          title="Your Trusted Real Estate Partner in"
          titleHighlight="Saudi Arabia"
          description="Personalized, professional, and ethical real estate services tailored to your needs—whether buying, selling, renting, or investing across the Kingdom."
          isBtn
        />
        <BrandMarquee />
        <AboutSection />
        <ServicesSection />

        <PropertyListings propertyData={propertyData} />
        <WhatSetsAsApart />
        <ClientTestimonials />
        <BlogInHome data={blogData} />
      </main>
      <Footer />
    </div>
  );
}