export const dynamic = "force-dynamic"; // forces dynamic rendering

import React from "react";
import Navbar from "../components/Navbar/Navbar";
import HeroSection from "../components/HeroSection";
import Footer from "../components/Footer";
import PropertiesCards from "../components/PropertiesCards";
import { baseUrl } from "@/lib/config";
import { cookies } from "next/headers";
import HeroParent from "../components/HeroParent";
// async function getData() {
  
//  const cookieStore = await cookies(); // ✅ Await cookies()

//     const token = cookieStore.get("sadu_auth_token")?.value;

//   const [propertyData] = await Promise.all([
//     fetch(`${baseUrl}/api/properties`, {
//       cache: "no-store",
//       headers: {
//         Authorization: `Bearer ${token}`,
//       },
//     }).then((res) => res.json()),
//   ]);

//   return { propertyData };
// }
export async function getData() {
  try {
    const cookieStore = await cookies();
    const token = cookieStore.get("sadu_auth_token")?.value;

    const headers = {
      "Content-Type": "application/json",
      ...(token ? { Authorization: `Bearer ${token}` } : {}), // ✅ Add only if token exists
    };

    const res = await fetch(`${baseUrl}/api/properties`, {
      cache: "no-store",
      headers,
    });

    if (!res.ok) {
      throw new Error(`HTTP Error: ${res.status}`);
    }

    const propertyData = await res.json();
    return { propertyData };
  } catch (error) {
    console.error("❌ Fetch failed:", error.message);
    return { propertyData: [] }; // ✅ Return empty array on failure
  }
}
export default async function PropertyPage() {
const {
    propertyData
   
  } = await getData();
  return (
    <div className="">
      <Navbar />
      <main className="">
        <HeroParent isProperties />
        {/* <HeroSection
          head="PROPERTIES LISTING"
          title="Explore Exceptional Property Listings Today"
          description="Discover a curated selection of residential and commercial properties designed to meet your lifestyle, business, and investment goals. From luxury homes to prime office spaces, our listings are regularly updated to help you find the perfect match with ease and confidence."
        /> */}
       <PropertiesCards data={propertyData} />
      </main>
      <Footer />
    </div>
  );
};

