"use client";
import i18next from "i18next";
import { initReactI18next } from "react-i18next";
import HttpBackend from "i18next-http-backend";

if (!i18next.isInitialized) {
  i18next
    .use(HttpBackend)
    .use(initReactI18next)
    .init({
      lng: "ar",
      fallbackLng: "ar",
      supportedLngs: [ "ar","en"],
      interpolation: { escapeValue: false },
      backend: {
        loadPath: "/locales/{{lng}}/{{ns}}.json",
      },
    });
}

export const i18n = i18next;
export { useTranslation } from "react-i18next";
