import { NextResponse } from 'next/server';

export function middleware(request) {
  const comingSoonPath = '/comingsoon';
  const currentPath = request.nextUrl.pathname;

  // Allow Coming Soon page and required assetsddd
  if (
    currentPath === comingSoonPath ||
    currentPath.startsWith('/_next') || // Next.js CSS/JS
    currentPath.startsWith('/favicon.ico') || // Optional favicon
    currentPath.startsWith('/images') // Your public images folder
  ) {
    return NextResponse.next();
  }

  // Redirect all other routes
  return NextResponse.redirect(new URL(comingSoonPath, request.url));
}

export const config = {
  matcher: '/:path*',
};