// "use client";
// import React, { useState } from "react";
import HeroSection from "../components/HeroSection";
import Footer from "../components/Footer";
import Navbar from "../components/Navbar/Navbar";
import Image from "next/image";
import { Input } from "@/components/ui/input";
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuItem,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu";
import { Button } from "@/components/ui/button";
// import { useRouter } from "next/navigation";
// import { articles } from "../data/blogData";
import { baseUrl } from "@/lib/config";
import BlogCards from "../components/blogComponents/BlogCards";
import HeroParent from "../components/HeroParent";
async function getData() {
  const [
    blogData
   
  ] = await Promise.all([
    fetch(`${baseUrl}/api/blogs`, { cache: "no-store" }).then(res => res.json())

  ]);

  return { blogData };
}
  export default async function BlogPage() {
   const {
    blogData
   
  } = await getData();
  // const router = useRouter();
// const [visibleCount, setVisibleCount] = useState(6);
// const totalArticles = blogData.length;
// const isAllVisible = visibleCount >= totalArticles;
  // const [selected, setSelected] = useState("");
//  const handleToggle = () => {
//   if (isAllVisible) {
//     setVisibleCount(6); 
//   } else {
//     setVisibleCount((prev) => prev + 6);
//   }
// };

  // const options = [
  //   "Price (Low to High)",
  //   "Price (High to Low)",
  //   "Date (Newest First)",
  //   "Date (Oldest First)",
  //   "Popularity",
  //   "Featured",
  // ];

  return (
    <div className="">
      <Navbar />
      <main className="">
       <HeroParent isBlogs/>
        {/* <div className="text-center pb-4">
          <div className=" text-primary mb-1  lg:mb-2 font-semibold">BLOG</div>
          <h2 className="text-[30px] md:text[35px] lg:text-[40px] font-semibold mb-0">
            Our Latest Articles
          </h2>
          <p className="lg:px-19 mx-auto mb-5 lg:mb-9 text-[#808080] max-w-[67%]">
            Static or dynamic description that can be updated via CMS.
          </p>
        </div>
        <div className="bg-ligbg py-[22px] px-5 md:px-[50px] lg:px-[96px]">
          <div className=" flex items-center justify-end gap-2">
            <div className="flex items-center gap-3 bg-white px-4 rounded-xl">
              <Image
                src="/icons/searchIcon.png"
                width={18}
                height={18}
                alt="twitter"
              />
              <Input
                placeholder="Search"
                className="bg-white border-0 ps-0 py-0 h-[48px] shadow-none focus-visible:outline-0 focus-visible:border-0 focus-visible:shadow-none  text-[16px] max-w-[450px] "
              />
            </div>

            <DropdownMenu className="h-[48px]">
              <DropdownMenuTrigger asChild className="focus-visible:ring-0">
                <Button className="bg-primary hover:bg-primary text-white text-[16px] h-12 flex items-center gap-2 px-3 md:px-6 md:h-[48px]">
                  <Image
                    src="/icons/sortIcon.png"
                    width={14}
                    height={16}
                    alt="sort icon"
                  />
                  Filter
                </Button>
              </DropdownMenuTrigger>

              <DropdownMenuContent className="w-[220px] mt-2 bg-white rounded-lg p-3">
                {options.map((option, index) => (
                  <DropdownMenuItem
                    key={index}
                    onClick={() => setSelected(option)}
                    className={`cursor-pointer focus:outline-0 my-1 px-2 rounded ${
                      selected === option ? "bg-primary text-white" : ""
                    }`}
                  >
                    {option}
                  </DropdownMenuItem>
                ))}
              </DropdownMenuContent>
            </DropdownMenu>
          </div>
        </div>

        <div className="grid sm:grid-cols-2 md:grid-cols-3 gap-[20px] lg:gap-[30px] text-start mb-5 lg:mb-8 px-5 md:px-[50px]  lg:px-[96px] mt-10">
          {blogData.slice(0, visibleCount).map((article, index) => (
            <div key={index} className="group ">
              <div className="relative w-full h-[280px] md:h-[350px]  lg:h-[420px]">
                <Image
                   src={article?.featuredImage?.url}
                alt={article?.featuredImage?.alt}
                  fill
                  className="rounded-lg"
                />
                <div className="absolute rounded-lg inset-0 bg-black/80 opacity-0 group-hover:opacity-100 transition duration-300"></div>

                <div
                  className="absolute inset-0 cursor-pointer flex items-center justify-center opacity-0 group-hover:opacity-100 transition duration-300"
                >
                    <Link href={`/blog/${article?.slug}`} className="cursor-pointer flex">

                  <Image
                    src="/icons/arrowWhite.png"
                    alt="arrow"
                    width={20}
                    height={20}z
                  /> </Link>
                </div>
              </div>

          {article.date && (
              <p className="my-1 lg:my-2">{article.date.split("T")[0]}</p>
            )}
              <p className="text-[14px] lg:text-[16px] ">{article.title}</p>
            </div>
          ))}
        </div>
        <div className="flex items-center pb-12 lg:pb-20">
        
 {totalArticles > 6 && (
  <Button
    onClick={handleToggle}
    className="bg-primary mx-auto mt-2 lg:mt-4 text-white text-[16px] font-normal flex items-center"
  >
    {isAllVisible ? "Show Less" : "Load More Articles"}
  </Button>
)}


        </div> */}
         <BlogCards blogData={blogData} />
      </main>
      <Footer />
    </div>
  );
};