'use client'
import { Card, CardContent, CardTitle } from '@/components/ui/card';
import Image from 'next/image';
import React from 'react'
import { useTranslation } from 'react-i18next';

const OurClientsPartners = () => {
      const { t } = useTranslation("about");
    
    const services = [
  {
    title: t("Our Mission"),
    desc: t("Our Mission Desc"),
    icon: "/icons/ourmission.png",
  },
  {
    title: t("Our Vision"),
    desc: t("Our Vision Desc"),
    icon: "/icons/ourvision.png",
  },
];
  return (
    <>
        <div className="grid gap-6 md:grid-cols-2 px-5 md:px-[50px] lg:px-[96px] mb-14 lg:mb-20">
          {services.map((service, index) => (
            <Card
              key={index}
              className="text-left py-0"
              style={{ boxShadow: "10px 10px 30px 0px #0000001A" }}
            >
              <CardContent className="p-7">
                <div className="flex gap-[15px] items-center  pb-5">
                  <Image
                    src={service?.icon}
                    alt="icons"
                    width={70}
                    height={70}
                  />
                  <CardTitle className={`text-xl font-semibold mb-2 `}>
                    {service.title}
                  </CardTitle>
                </div>
                <p className=" mb-4 pt-2">{service.desc}</p>
              </CardContent>
            </Card>
          ))}
        </div>
        <div className="text-center mt-5">
          <div className=" text-primary mb-1 lg:mb-2 font-semibold">{t("PARTNERS")}</div>
          <h2 className="text-[30px] md:text-[35px] lg:text-[40px] font-semibold mb-2">
            {t("Our Clients &")} <span className="text-primary">{t("Partners")}</span>
          </h2>
          <p className="px-4 lg:px-19 mx-auto mb-10 w-full sm:max-w-[80%] md:max-w-[70%]">
           {t("Our Clients & Partners Desc")}
          </p>
        </div>
        </>
  )
}

export default OurClientsPartners