'use client'
import Image from 'next/image'
import React from 'react'
import { useTranslation } from 'react-i18next';

const OurValues = () => {
          const { t } = useTranslation("about");
  
    const articles = [
    {
      title: t("Integrity"),
      icon: "/icons/ourValues/solutions 1.png",
      desc: t("Integrity desc"),
    },
    {
      title: t("Client-Centricity"),
    icon: "/icons/ourValues/solutions 2.png",
      desc: t("Client-Centricity desc"),
    },
    {
      title: t("Professionalism"),
       icon: "/icons/ourValues/solutions 3.png",
      desc: t("Professionalism desc"),
    },
    {
      title: t("Passion"),
       icon: "/icons/ourValues/solutions 4.png",
      desc: t("Passion desc"),
    },
    {
      title: t("Excellence"),
        icon: "/icons/ourValues/solutions 5.png",
      desc: t("Excellence desc"),
    },
    
    
  ];
  return (
      <div className="text-center px-5 md:px-[50px] lg:px-[96px] pb-8 lg:pb-20 pt-10">
          <div className=" text-primary lg:mb-2 font-semibold">{t("VALUES")}</div>
          <h2 className="text-[30px] md:text-[35px] lg:text-[40px] font-semibold mb-0">
            {t("Our Values")}
          </h2>
          <p className="lg:px-19 mx-auto mb-6 md:mb-9 text-[#808080] w-full sm:max-w-[75%] md:max-w-[67%]">
           {t("Desc")}
          </p>
    
          <div className="grid sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-5 gap-[15px] text-cenetr  mb-8">
            {articles.map((article, index) => (
              <div key={index} className="bg-secordary rounded-3xl">
                <div className=" text-center mx-auto flex items-center w-full justify-center px-3 py-5 my-4">
                  <Image
                    src={article?.icon}
                    alt="City"
                    width={50}
                    height={50}
                    className="rounded-xl"
                  />
                </div>
                <div className="text-white rounded-2xl mx-2">
                  <p className="text-[17px] font-bold">{article.title}</p>
                 
                  <p className="text-[16px] font-light mb-4">{article.desc}</p>
                
                </div>
              </div>
            ))}
          </div>
         
        </div>
  )
}

export default OurValues