'use client'
import { Button } from '@/components/ui/button'
import Image from 'next/image'
import Link from 'next/link'
import React from 'react'
import { useTranslation } from 'react-i18next'

const AboutSection = () => {
    const { t } = useTranslation("home");
  
  return (
     <section className="bg-white px-5 md:px-[50px] lg:px-[96px] w-full py-16 md:flex gap-[30px] lg:gap-[64px] justify-between items-center">
          <div className="md:w-1/2 space-y-4">
            <div className="flex gap-1 items-center mb-0">
              <div className="h-[1px] w-15 bg-primary rounded-full"></div>
              <p className=" text-primary font-semibold">{t("WELCOME TO SADU")}</p>
            </div>
            <h1 className="text-[35px] md:text-[37px] lg:text-[45px] font-bold">
              {t("Building dreams into stunning")}{" "}
              <span className="text-primary">{t("real estate")}</span>
            </h1>
            <p className="">
              {t("about description")}
            </p>
            <div className="flex gap-4 mt-5 lg:mt-10">
               <Link href='/about' className="cursor-pointer">
              <Button className="bg-primary cursor-pointer text-white text-[16px] px-6">
               {t("More About Us")}
              </Button>
              </Link>
            </div>
          </div>
          <div className="md:w-1/2 flex justify-end mt-8 md:mt-0">
            <div className="relative w-full md:max-w-[680px] h-[370px] mx-auto">
              <div className='absolute top-0 right-0 rounded-xl'>
              <div className='relative w-[280px] sm:w-[450px] md:w-[250px] h-[220px] sm:h-[300px] lg:w-[320px] lg:h-[370px]'>
              <Image
                src="/images/house/h2.jpg.png"
                alt="City"
              fill
                className="rounded-xl absolute top-0 right-0"
              />
              </div>
              </div>
              <div className='absolute bottom-[50px] sm:bottom-[-1px] lg:bottom-[-50px] left-[11%] sm:left-[0%] lg:left-[20%] rounded-xl'>
              <div className='relative w-[250px] sm:w-[300px]  md:w-[220px] h-[180px] sm:h-[220px] lg:w-[259px] lg:h-[270px]'>
              <Image
                src="/images/house/h1.jpg.png"
                alt="City"
               fill
                className="rounded-xl absolute bottom-[-50px] left-[1%] lg:left-[20%]"
              /></div></div>
            </div>
          </div>
        </section>
  )
}

export default AboutSection