"use client";

import { Input } from "@/components/ui/input";
import { Button } from "@/components/ui/button";
import Image from "next/image";
import Link from "next/link";
import { useTranslation } from "react-i18next";

export default function Footer() {
          const { t,i18n } = useTranslation("footer");
  
  return (
    <footer className="bg-secordary px-5  md:px-[50px] lg:px-[95px] pt-[150px] sm:pt-[100px] md:pt-[120px] lg:pt-[200px] mt-[130px] md:mt-[150px] lg:mt-[200px] pb-8 rounded-t-lg relative">
      <div className="w-[90%] sm:w-[82%] mx-auto absolute -top-[100px] sm:-top-[130px] md:-top-[150px] lg:-top-[190px] left-[50%] -translate-x-[50%]">
        <div className="bg-ligbg py-3 px-4  md:p-5 lg:p-[40px] rounded-lg relative ">
          <h1 className="text-[22px] sm:text-[30px] md:text-[35px] lg:text-[48px] font-semibold ">
            {t("Find your")} <span className="text-primary">{t("dream home")} </span>{t("today!")}
          </h1>
          <p className="sm:max-w-[70%] md:max-w-[60%] lg:max-w-[45%] mt-2">
          {t("cta description")}
          </p>
        
          <Link href="/contact" className="cursor-pointer">
            <Button className="cursor-pointer bg-primary mx-auto mt-5 sm:mt-8 lg:mt-15 text-white text-[12px]  sm:text-[16px] font-normal">
              {t("Contact Us")}{" "}
              <Image
                src="/icons/arrowWhite.png"
                alt="arrow"
                width={12}
                height={12}
                className="ml-2"
              />
            </Button>
          </Link>
          {/* <div className="absolute bottom-1 sm:bottom-1 md:bottom-0 lg:bottom-10 right-4 sm:right-5 lg:right-10 z-40 w-[220px] sm:w-[300px] h-[100px] sm:h-[130px] md:w-[400px] md:h-[180px] lg:w-[600px] lg:h-[227px]  "> */}
          <div
  className={`absolute bottom-1 sm:bottom-1 md:bottom-0 lg:bottom-10 
    ${i18n.language === "ar" ? "left-4 sm:left-5 lg:left-10" : "right-4 sm:right-5 lg:right-10"} 
    z-40 w-[220px] sm:w-[300px] h-[100px] sm:h-[130px] md:w-[400px] md:h-[180px] lg:w-[600px] lg:h-[227px]`}
>
            <div className="relative w-full h-full ">
              <Image
                src="/icons/callToActionImage.png"
                alt="arrow"
                fill
                className="z-50 object-contain"
              />
            </div>
          </div>
        </div>
      </div>
      <div className=" text-white md:flex gap-5 lg:gap-8 items-ceter  border-b border-gray-600 pb-8">
        {/* Logo + Description */}
        <div className="md:max-w-[43%] lg:max-w-[38%] ">
          <Image
            src="/images/sadu-logo.png"
            width={60}
            height={60}
            alt="twitter"
          />
          <p className="text-[12px] lg:text-sm mt-2 leading-6">
           {t("desc")}
          </p>
          <div className="mt-5 lg:mt-8 flex items-center gap-2">
            <Input
              placeholder={t("Email")}
              className="bg-transparent text-white border border-bor h-[40px] lg:h-[55px] text-[14px] lg:text-[18px]"
            />
            <Button className="bg-primary hover:bg-primary md:h-[40px] lg:h-[55px] text-white text-[12px] lg:text-[16px] ">
             {t("Subscribe")}
            </Button>
          </div>
        </div>

        {/* Links */}
        <div className="flex items-strat justify-between w-full mt-5 md:mt-0">
        <div className="text-[14px] lg:text-[16px]">
          <h3 className=" mb-5 underline">{t("Quick Links")}</h3>
          <ul className="space-y-5">
            <li className="hover:text-primary cursor-pointer">
              <Link href="/home" className="cursor-pointer">
                {t("Home")}
              </Link>
            </li>
            <li className="hover:text-primary cursor-pointer">
              <Link href="/about">{t("About Us")}</Link>
            </li>
            <li className="hover:text-primary cursor-pointer">
              <Link href="/services">{t("Services")}</Link>
            </li>
            <li className="hover:text-primary cursor-pointer">
              <Link href="/contact">{t("Contact")}</Link>
            </li>
            <li className="hover:text-primary cursor-pointer">
              <Link href="/blogs">{t("Blog")}</Link>
            </li>
          </ul>
        </div>
        {/* info// */}
        <div className="text-[14px] lg:text-[16px]">
          <h3 className=" mb-5 underline">{t("Information")}</h3>
          <ul className="space-y-5">
            <li className="hover:text-primary"><Link href="/contact">{t("Contact us")}</Link></li>
            <li className="hover:text-primary">{t("Privacy Policy")}</li>
            <li className="hover:text-primary">{t("FAQ")}</li>
          </ul>
        </div>
        {/* Contact Info + Social */}
        <div className="text-[13px] lg:text-[14px]">
          <h3 className=" mb-5 underline">{t("Contact Information")}</h3>
          <ul className="space-y-5 ">
            <li className="hover:text-primary">{t("+966- XXX-XXXXX")}</li>
            <li className="hover:text-primary">{t("info@sadurealestate.sa")}</li>
            <li className="hover:text-primary">{t("+966- XXX-XXXXX")}</li>
          </ul>
          <div className="grid grid-cols-2 sm:grid-cols-4 md:grid-cols-2 lg:grid-cols-4 gap-2 lg:gap-3 mt-5">
            <Button
              variant="ghost"
              size="icon"
              className="bg-transparent border border-bor hover:border-0 text-white hover:bg-primary h-[40px] max-w-[40px] min-w-[40px] w-[40px]"
            >
              <div className="relative w-[18px] h-[15px]">
              <Image
                src="/icons/twitter.png"
                fill
                alt="twitter"
                className="object-cover"
              /></div>
            </Button>
            <Button
              variant="outline"
              size="icon"
              className="bg-transparent border border-bor hover:border-0 text-white hover:bg-primary h-[40px] w-[40px]"
            >
              <Image
                src="/icons/facebook.png"
                width={10}
                height={18}
                alt="facebook"
              />
            </Button>
            <Button
              variant="outline"
              size="icon"
              className="bg-transparent border border-bor hover:border-0 text-white hover:bg-primary h-[40px] w-[40px]"
            >
              <Image
                src="/icons/linkedin.png"
                width={18}
                height={18}
                alt="linkedin"
              />
            </Button>
            <Button
              variant="outline"
              size="icon"
              className="bg-transparent border border-bor hover:border-0 text-white hover:bg-primary h-[40px] w-[40px]"
            >
              <Image
                src="/icons/vimeo.png"
                width={18}
                height={15}
                alt="vimeo"
              />
            </Button>
          </div>
        </div>
        </div>
      </div>

      {/* Footer bottom */}
      <div className="text-center text-[14px] md:text-[16px] pt-6 text-white">
        2025 © Sadu Real Estate. All rights reserved.
      </div>
    </footer>
  );
}
