"use client";
import { Button } from "@/components/ui/button";
import Image from "next/image";
import React, { useState } from "react";
import {
  Carousel,
  CarouselContent,
  CarouselItem,
  CarouselNext,
  CarouselPrevious,
} from "@/components/ui/carousel";
import Link from "next/link";
import { useTranslation } from "react-i18next";
const images = [
  "/images/house/27-Riyadhs-Rising-Skyline-Demonstrates-Saudi-Arabias-Global-Ambitions (1).png",
  "/images/house/27-Riyadhs-Rising-Skyline-Demonstrates-Saudi-Arabias-Global-Ambitions (1).png",
  "/images/house/27-Riyadhs-Rising-Skyline-Demonstrates-Saudi-Arabias-Global-Ambitions (1).png",
  "/images/house/27-Riyadhs-Rising-Skyline-Demonstrates-Saudi-Arabias-Global-Ambitions (1).png",
  "/images/house/27-Riyadhs-Rising-Skyline-Demonstrates-Saudi-Arabias-Global-Ambitions (1).png",
];

const HeroSection = ({
  head,
  title,
  titleHighlight,
  description,
  description2,
  isBtn,
  titleHighlightProperties,
}) => {
  const [value, setValue] = useState("0");
  const length = images.length;
  const { t } = useTranslation("home");

  const goPrev = () => {
    const idx = parseInt(value, 10);
    const nextIdx = (idx - 1 + length) % length;
    setValue(String(nextIdx));
  };
  const goNext = () => {
    const idx = parseInt(value, 10);
    const nextIdx = (idx + 1) % length;
    setValue(String(nextIdx));
  };
  return (
    <section className="bg-white px-5 md:px-[50px] lg:px-[96px] w-full py-16 md:flex gap-[25px] lg:gap-[54px] justify-between items-strat">
      <div className="md:w-1/2 space-y-4">
        <div className="flex gap-1 items-center mb-0">
          <div className="h-[1px] w-15 bg-primary rounded-full"></div>
          <p className=" text-primary font-semibold">{head}</p>
        </div>
        <h1 className="text-[35px] lg:text-[45px] font-bold">
          {title} <span className="text-primary">{titleHighlight}</span>
        </h1>
        <p className="">{description}</p>
        {description2 ? <p className="">{description2}</p> : null}
        {isBtn ? (
          <div className="flex gap-4 mt-5 lg:mt-10">
            <Link href="/properties" className="cursor-pointer">
              <Button className="bg-primary text-white text-[14px] md:text-[16px] px-4 md:px-6 cursor-pointer">
                {t("New Properties")}
              </Button>
            </Link>
            <Link href="/contact" className="cursor-pointer">
              <Button
                variant="outline"
                className="bg-transparent border-primary text-[14px] md:text-[16px]  px-4 md:px-6 cursor-pointer"
              >
                {t("Contact Us")}
              </Button>
            </Link>
          </div>
        ) : null}
      </div>
      <div className="md:w-1/2 flex justify-end mt-8 md:mt-0">
        <div className="w-full max-w-[700px]">

          <Carousel
            value={value}
            onValueChange={setValue}
            className="w-full h-[370px] lg:h-[450px]"
          >
            <CarouselContent className="h-full">
              {images.map((src, index) => (
                <CarouselItem
                  key={index}
                  value={String(index)}
                  className=" w-full h-[370px] lg:h-[450px]"
                >

                  <div className="relative h-full w-full rounded-xl overflow-hidden">
                    <Image
                      src={src}
                      alt={`slide-${index + 1}`}
                      fill
                      style={{ objectFit: "cover" }}
                    />
                  </div>
                </CarouselItem>
              ))}
            </CarouselContent>

            <div
              onClick={goPrev}
              className="absolute left-0 top-1/2 -translate-y-1/2 z-10"
              aria-hidden
            >
              <CarouselPrevious />
            </div>
            <div
              onClick={goNext}
              className="absolute right-0 top-1/2 -translate-y-1/2 z-10"
              aria-hidden
            >
              <CarouselNext />
            </div>
          </Carousel>
          <div className="mt-2">
            <div className="flex items-center gap-3 justify-center px-2">
              {images.map((_, idx) => {
                const active = parseInt(value, 10) === idx;
                return (
                  <button
                    key={idx}
                    onClick={() => setValue(String(idx))}
                    aria-current={active}
                    className="flex-1 max-w-[120px] md:max-w-[160px] focus:outline-none px-1"
                  >
                    <div className="w-full flex items-center justify-center">
                      <div
                        className={`transition-all duration-200 rounded-full ${active ? "bg-primary h-1" : "bg-gray-200 h-1"
                          } w-full`}
                        style={{ borderRadius: 8 }}
                      />
                    </div>
                  </button>
                );
              })}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default HeroSection;
