"use client";
import { Select, SelectContent, SelectGroup, SelectItem, SelectLabel, SelectTrigger, SelectValue } from "@/components/ui/select";
import Image from "next/image";
import React, { useEffect, useState } from "react";
import { useTranslation, i18n } from "@/lib/i18n";

const NavHead = () => {
  const { t } = useTranslation("common");
   const [currentLang, setCurrentLang] = useState("ar");

  // keep local state in sync with i18n
  useEffect(() => {
    if (i18n.language) {
      setCurrentLang(i18n.language);
      document.documentElement.lang = i18n.language;
      document.documentElement.dir = i18n.language === "ar" ? "rtl" : "ltr";
    }
  }, [i18n.language]);

  const handleChange = (value) => {
    i18n.changeLanguage(value);
    setCurrentLang(value);
    document.documentElement.lang = value;
    document.documentElement.dir = value === "ar" ? "rtl" : "ltr";
  };
  return (
    <div className="bg-primary flex items-center justify-between py-[12px] px-2 md:px-[50px] lg:px-[96px]">
      <div className="flex items-center text-[8px] md:text-[11.3px] lg:text-[13.3px] text-white gap-1 justify-center">
        <Image
          src="/icons/location.png"
          width={12}
          height={16}
          alt="location"
        />
        <p>Sadu Real Estate, [Full Office Address], Saudi Arabia</p>
      </div>
      <div className="flex items-center justify-center gap-3 lg:gap-[30px]">
         <Select value={currentLang} onValueChange={handleChange}>
        <SelectTrigger className="rounded h-[20px] w-[70px] text-[10px] text-white">
          <SelectValue placeholder={currentLang} />
        </SelectTrigger>
        <SelectContent className="bg-white shadow rounded-lg z-40">
          <SelectGroup>
            <SelectLabel>Select Language</SelectLabel>
            <SelectItem value="en">English</SelectItem>
            <SelectItem value="ar">العربية</SelectItem>
          </SelectGroup>
        </SelectContent>
      </Select>
              <div className="hidden md:block">
              <div className="flex gap-3 lg:gap-[30px]">
        <div className="flex items-center text-[8px] md:text-[11.3px] lg:text-[13.3px] text-white gap-1 justify-center">
          <Image src="/icons/phone.png" width={12} height={16} alt="location" />
          <p>+966 XXXXXXXXX</p>
        </div>
        <div className="flex items-center text-[8px] md:text-[11.3px] lg:text-[13.3px] text-white gap-1 justify-center">
          <Image src="/icons/mail.png" width={12} height={16} alt="location" className="pt-0" />
          <p>info@sadurealestate.sa</p>
        </div>
        </div>
        </div>
      </div>
    </div>
  );
};

export default NavHead;
