"use client";
import {
  Card,
  CardContent,
  CardFooter,
  CardHeader,
} from "@/components/ui/card";

import Image from "next/image";
import { Button } from "@/components/ui/button";
import Link from "next/link";
import { useRouter } from "next/navigation";
import { useTranslation } from "react-i18next";

export function PropertyListings({propertyData}) {
        const { t } = useTranslation("home");
  
  const router = useRouter();
  const listings = [
    {
      title: "Houses on the Hollywood",
      slug: "houses-on-the-hollywood",
      location: "Al Cloops",
      features: {
        beds: "3",
        baths: "6",
        area: "200 sqft",
      },
      status: "For Sale",
      price: "5,800,000 SAR",
      isFeatured: "Featured",
    },
    {
      title: "Comfortable Villa Green",
      slug: "comfortable-villa-green",
      location: "Flyerin",
      features: {
        beds: "3",
        baths: "6",
        area: "200 sqft",
      },
      status: "For Sale",
      price: "4,600,000 SAR",
      isFeatured: "Featured",
    },
    {
      title: "Luxury Apartment",
      slug: "luxury-apartment",
      location: "Riyadh",
      features: {
        beds: "100",
        baths: "6",
        area: "200 sqft",
      },
      status: "For Sale",
      price: "3,200,000 SAR",
    },
  ];

  return (
    <div className="text-center mx-auto px-5 md:px-[50px] lg:px-[96px] py-7 md:py-9 lg:py-12">
      <h1 className=" text-primary mb-0 lg:mb-2 font-semibold">{t("LISTINGS")}</h1>
      <h2 className="text-[30px] md:text-[35px] lg:text-[40px] font-semibold mb-0">
        {t("Our Latest")} <span className="text-primary">{t("Listings")}</span>
      </h2>
      <p className="sm:px-7 md:px-18 lg:px-19 mx-auto mb-9 text-[#808080] w-full sm:max-w-[90%] lg:max-w-[67%]">
       {t("listing description")}
      </p>

      <div className="grid sm:grid-cols-2 md:grid-cols-3 gap-4 lg:gap-[30px] text-start ">
        {listings.map((listing, index) => (
          <Card
           
            key={index}
            className="h-full  py-0 rounded-t-xl gap-2 lg:gap-5"
          >
            <div  onClick={() => {
              if (typeof window !== "undefined" && listing?.slug) {
                window.open(`/property/${listing.slug}`, "_blank");
              }
            }} className="h-[200px] lg:h-[240px] w-full relative cursor-pointer">
              {listing?.isFeatured ? (
                <div className="bg-primary absolute top-4 left-3 z-10 w-[100px] h-[30px] rounded">
                  <div className="flex items-center gap-2 text-white h-full justify-center">
                    <Image
                      width={13}
                      height={14}
                      src="/icons/listingCardIcons/Vector (2).png"
                      alt="featured"
                    />
                    <p className="text-[12px] font-semibold">
                      {listing?.isFeatured}
                    </p>
                  </div>
                </div>
              ) : null}

              <div className="bg-white absolute bottom-4 left-3 z-10 px-3 h-[30px] rounded">
                <div className="flex items-center h-full justify-center">
                  <p className="text-[12px] font-semibold">{listing?.price}</p>
                </div>
              </div>
              <Image
                src="/images/house/p2-570x370.jpg.png"
                fill
                alt="sadu-logo"
                className="cursor-pointer rounded-t-xl"
              />
            </div>
            <CardHeader  onClick={() => {
              if (typeof window !== "undefined" && listing?.slug) {
                window.open(`/property/${listing.slug}`, "_blank");
              }
            }} className="ps-2 md:ps-3 lg:ps-5 cursor-pointer">
              <h3 className="font-semibold text-[15px]">{listing.title}</h3>
              <p className="text-sm text-gray-500">{listing.location}</p>
            </CardHeader>
            <CardContent  onClick={() => {
              if (typeof window !== "undefined" && listing?.slug) {
                window.open(`/property/${listing.slug}`, "_blank");
              }
            }} className="px-2 md:px-3 lg:px-5 cursor-pointer">
              <div className="flex items-center gap-3 lg:gap-5 border-b pb-2 lg:pb-4">
                <div className="flex items-center gap-1 ">
                  <Image
                    width={20}
                    height={18}
                    src="/icons/listingCardIcons/Vector (3).png"
                    alt="featured"
                  />
                  <p className="pt-1">{listing?.features?.beds}</p>
                </div>
                <div className="flex items-center gap-1 ">
                  <Image
                    width={20}
                    height={18}
                    src="/icons/listingCardIcons/Vector (4).png"
                    alt="featured"
                  />
                  <p className="pt-1">{listing?.features?.baths}</p>
                </div>
                <div className="flex items-center gap-1 ">
                  <Image
                    width={20}
                    height={18}
                    src="/icons/listingCardIcons/Vector (5).png"
                    alt="featured"
                  />
                  <p className="pt-1">{listing?.features?.area}</p>
                </div>
              </div>
            </CardContent>
            <CardFooter className="flex items-center justify-between">
              <h4 className="self-start text-[13px] font-bold text-primary">
                {listing.status}
              </h4>
              <div className="flex items-center gap-4 pb-5">
                <Image
                  onClick={() => router.push(`/property/${listing?.slug}`)}
                  width={19}
                  height={19}
                  src="/icons/listingCardIcons/Vector (6).png"
                  alt="featured"
                  className="cursor-pointer"
                />
                <Image
                  width={21}
                  height={18}
                  src="/icons/listingCardIcons/Vector (7).png"
                  alt="featured"
                />
                <Image
                  width={19}
                  height={19}
                  src="/icons/listingCardIcons/Vector (8).png"
                  alt="featured"
                />
              </div>
            </CardFooter>
          </Card>
        ))}
      </div>
      <div className="flex items-center justify-center">
        <Link href="/properties">
          <Button className="bg-primary mx-auto mt-5 md:mt-7 lg:mt-10 text-white text-[16px] font-normal">
            {t("View All Listings")}
          </Button>
        </Link>
      </div>
    </div>
  );
}
