'use client'
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardTitle } from "@/components/ui/card";
import Image from "next/image";
import Link from "next/link";
import React from "react";
import { useTranslation } from "react-i18next";
//  {
//                   href: "/service/buying-and-selling",
//                   label: "Buying & Selling",
//                 },
//                 {
//                   href: "/service/rentals-and-management",
//                   label: "Rentals & Management",
//                 },
//                 {
//                   href: "/service/valuation-and-Advisory",
//                   label: "Valuation & Advisory",
//                 },
//                 {
//                   href: "/service/luxury-properties",
//                   label: "Luxury Properties",
//                 },
//                 {
//                   href: "/service/new-developments",
//                   label: "New Developments",
//                 },
//                 {
//                   href: "/service/hoa-and-facility-management",
//                   label: "HOA & Facility Management",
//                 },


const ServicesSection = () => {
      const { t } = useTranslation("home");
  const services = [
  {
    title: t("Buying & Selling"),
    desc: t("Buying & SellingD"),
    slug: "/service/buying-and-selling",
    color: "text-blue-500",
    icon: "/icons/Group 1321315333.png",
  },
  {
    title: t("Rentals & Management"),
    desc: t("Rentals & ManagementD"),
    slug: "/service/rentals-and-management",
    color: "text-green-500",
    icon: "/icons/Group 1321315334.png",
  },
  {
    title: t("Valuation & Advisory"),
    desc: t("Valuation & AdvisoryD"),
    slug: "/service/valuation-and-Advisory",
    color: "text-pink-500",
    icon: "/icons/Group 1321315335.png",
  },
  {
    title: t("Luxury Properties"),
    desc: t("Luxury PropertiesD"),
    slug: "/service/luxury-properties",
    color: "text-purple-500",
    icon: "/icons/Group 1321315336.png",
  },
  {
    title: t("New Developments"),
    desc: t("New DevelopmentsD"),
    slug: "/service/new-developments",
    color: "text-yellow-500",
    icon: "/icons/Group 1321315337.png",
  },
  {
    title: t("HOA & Facility Management"),
    desc: t("HOA & Facility ManagementD"),
    slug: "/service/hoa-and-facility-management",
    color: "text-red-500",
    icon: "/icons/Group 1321315338.png",
  },
];
  return (
    <section className="bg-ligbg py-10 lg:py-16 text-center">
      <div className="px-8 md:px-[50px] lg:px-[96px]">
        <div className=" text-primary mb-3 lg:mb-7 font-semibold">{t("Services")}</div>
        <h2 className="text-[30px] md:text-[35px] lg:text-[40px] font-semibold mb-2">
          {t("Explore")} <span className="text-primary">{t("Our Services")}</span>
        </h2>
        <p className="sm:px-10 md:px-14 lg:px-19 mx-auto mb-10">
          {t("services description")}
        </p>

        <div className="grid gap-4 lg:gap-6 sm:grid-cols-2 md:grid-cols-3">
          {services.map((service, index) => (
            <Card
              key={index}
              className="text-left hover:shadow-lg transition py-0"
            >
              <CardContent className="md:px-5 lg:px-7 py-5 lg:py-7">
                <div className="flex gap-2 lg:gap-[15px] items-center border-b pb-2 border-[#D4D4D4]">
                  <div className="relative object-cover w-[50px] h-[50px] lg:w-[70px] lg:h-[70px] whitespace-nowrap pe-3">
                  <Image
                    src={service?.icon}
                    alt="icons"
                    className="object-center"
                  fill
                  /></div>
                  <CardTitle className={`text-[14px] lg:text-xl font-semibold mb-2 `}>
                    {service.title}
                  </CardTitle>
                </div>
                <p className=" mb-4 pt-2">{service.desc}</p>
                <div className="flex ">
                  <Link href={service?.slug}>
                    <Button
                      variant="outline"
                      className="bg-transparent border-primary px-5 md:h-[40px] lg:[50px] text-primary ml-auto"
                    >
                      {t("Learn More")}
                    </Button>
                  </Link>
                </div>
              </CardContent>
            </Card>
          ))}
        </div>
        <Link href="/services">
          <Button className="bg-primary cursor-pointer mt-10 text-white text-[16px] font-normal">
           {t("Explore All Services")}
          </Button>
        </Link>
      </div>
    </section>
  );
};

export default ServicesSection;
