"use client";
import React, { useMemo, useState } from "react";
import Image from "next/image";
import Link from "next/link";
import { Input } from "@/components/ui/input";
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuItem,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu";
import { Button } from "@/components/ui/button";
import { useTranslation } from "react-i18next";

export default function BlogCards({ blogData }) {
  console.log('blogDatablogData', blogData)
        const { t } = useTranslation("blogs"); 
  
  const [visibleCount, setVisibleCount] = useState(6);
  const [selected, setSelected] = useState("");
  const [searchTerm, setSearchTerm] = useState("");

  const totalArticles = blogData.length;
  const isAllVisible = visibleCount >= totalArticles;

  const handleToggle = () => {
    setVisibleCount(isAllVisible ? 6 : visibleCount + 6);
  };

  const options = [
    "Price (Low to High)",
    "Price (High to Low)",
    "Date (Newest First)",
    "Date (Oldest First)",
    "Popularity",
    "Featured",
  ];
  const filteredArticles = useMemo(() => {
    return blogData.filter((article) => {
      const titleMatch = article.title
        ?.toLowerCase()
        .includes(searchTerm.toLowerCase());
      const dateString = article.date
        ? article.date.split("T")[0] // YYYY-MM-DD
        : "";
      const dateMatch = dateString.includes(searchTerm);
      return titleMatch || dateMatch;
    });
  }, [blogData, searchTerm]);
  return (
    <>
      {/* Search + Filter */}
      <div className="bg-ligbg py-[22px] px-5 md:px-[50px] lg:px-[96px]">
        <div className="flex items-center justify-end gap-2">
          <div className="flex items-center gap-3 bg-white px-4 rounded-xl">
            <Image
              src="/icons/searchIcon.png"
              width={18}
              height={18}
              alt="search"
            />
            <Input placeholder={t("Search")} value={searchTerm}
              onChange={(e) => setSearchTerm(e.target.value)} className="bg-white border-0" />
          </div>

          <DropdownMenu>
            <DropdownMenuTrigger asChild>
              <Button className="bg-primary text-white">{t("Filter")}</Button>
            </DropdownMenuTrigger>
            <DropdownMenuContent>
              {options.map((option, index) => (
                <DropdownMenuItem
                  key={index}
                  onClick={() => setSelected(option)}
                >
                  {option}
                </DropdownMenuItem>
              ))}
            </DropdownMenuContent>
          </DropdownMenu>
        </div>
      </div>

      {/* Blog Cards */}
      <div className="grid sm:grid-cols-2 md:grid-cols-3 gap-[20px] px-5 md:px-[50px] lg:px-[96px] mt-10">
        {filteredArticles.slice(0, visibleCount).map((article, index) => (
          <div key={index} className="group">
            <div className="relative w-full h-[280px] md:h-[350px] lg:h-[420px]">
              {article?.featuredImage?.url &&
              <Image
                src={article?.featuredImage?.url}
                alt={article?.featuredImage?.alt || ""}
                fill
                className="rounded-lg"
              />}
              <div className="absolute rounded-lg inset-0 bg-black/80 opacity-0 group-hover:opacity-100 transition duration-300"></div>
              <div className="absolute inset-0 flex items-center justify-center opacity-0 group-hover:opacity-100 transition duration-300">
                <Link href={`/blog/${article?.slug}`}>
                  <Image
                    src="/icons/arrowWhite.png"
                    alt="arrow"
                    width={20}
                    height={20}
                  />
                </Link>
              </div>
            </div>
            {article.date && <p className="my-1">{article.date.split("T")[0]}</p>}
            <p>{article.title}</p>
          </div>
        ))}
      </div>

      {/* Load More */}
      {totalArticles > 6 && (
        <div className="flex items-center pb-12 lg:pb-20">
          <Button
            onClick={handleToggle}
            className="bg-primary mx-auto mt-4 text-white"
          >
            {isAllVisible ? t("Show Less") : t("Load More Articles")}
          </Button>
        </div>
      )}
    </>
  );
}
