"use client"
import React from 'react'
import { useTranslation } from 'react-i18next'

const Location = () => {
    const { t }= useTranslation("propertyDetail")
  return (
<div className="mt-[32px]  ">
          <h1 className="font-semibold text-lg md:text-xl lg:text-2xl text-black text-left">
            {t("Map Location")}
          </h1>
          <div className="grid grid-cols-1 lg:grid-cols-[73%_27%] gap-[22px] h-auto">
            {/* Column 1 – Map */}
            <div className="w-full h-full mt-3 lg:mt-[6px] ">
              <iframe
                className="w-full h-auto min-h-[320px] rounded-2xl"
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3624.568897470082!2d46.68312207588341!3d24.716990478052636!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3e2f03c8ec5b64e1%3A0xa3b74e7757687790!2sAl%20Olaya%2C%20Riyadh%2012233%2C%20Saudi%20Arabia!5e0!3m2!1sen!2sus!4v1722234342342!5m2!1sen!2sus"
                allowFullScreen=""
                loading="lazy"
                referrerPolicy="no-referrer-when-downgrade"
              ></iframe>
            </div>
            {/* Column 2 – Text Box */}
            <div className="bg-[#F8F8F8] py-[25px]  h-auto mt-[6px] w-full rounded-2xl min-h-[310px] justify-center">
              <h1 className="text-primary font-bold text-2xl leading-[120%] text-center">
                {t("Get Free Property Consultation")}
              </h1>
              <p className="pt-[25px] text-center text-sm font-normal px-[16px]">
                {t("Are You Ready To BuyAnd Sell Your Property IN Duai")}
              </p>
              <div className="mx-[23px] pt-[25px] grid grid-cols-2 lg:flex lg:flex-row justify-between items-center gap-3 h-[100px] lg:h-auto">
                <div className="w-full lg:w-[128px] h-1/2 lg:h-[40px] rounded-lg bg-primary flex justify-center items-center gap-2">
                  <img
                    src="/icons/getPropertyConsultation/Vector (18).png"
                    alt=""
                    className="h-[20px] w-[20px]"
                  />
                  <p className="text-white text-base font-normal">{t("CALL")}</p>
                </div>
                <div className="w-full lg:w-[128px] h-1/2 lg:h-[40px] rounded-lg bg-primary flex justify-center items-center gap-2">
                  <img
                    src="/icons/getPropertyConsultation/Vector (19).png"
                    alt=""
                    className="h-[14px] w-[18px]"
                  />
                  <p className="text-white text-base font-normal">{t("MAIL")}</p>
                </div>
              </div>
              <div className="pt-[20px] flex justify-center items-center mx-[23px]">
                <div className="w-full h-[40px] rounded-lg bg-[#5FDA3E] flex justify-center items-center gap-2">
                  <img
                    src="/icons/getPropertyConsultation/logos_whatsapp-icon.png"
                    alt=""
                    className="h-[22px] w-[22px]"
                  />
                  <p className="text-white text-base font-normal">{t("WHATSAPP")}</p>
                </div>
              </div>
            </div>
          </div>
        </div>  )
}

export default Location