"use client";
import {
  Card,
  CardContent,
  CardFooter,
  CardHeader,
} from "@/components/ui/card";

import Image from "next/image";
import { Button } from "@/components/ui/button";
import { useRouter } from "next/navigation";
import { useTranslation } from "react-i18next";

export function PropertyListingsRelated({relatedProperties}) {
  const { t } = useTranslation("propertyDetail")
  const router = useRouter();
  const listings = [
    {
      title: "Houses on the Hollywood",
      slug: "houses-on-the-hollywood",
      location: "Al Cloops",
      features: {
        beds: "3",
        baths: "6",
        area: "200 sqft",
      },
      status: "For Sale",
      price: "5,800,000 SAR",
      isFeatured: "Featured",
    },
    {
      title: "Comfortable Villa Green",
      slug: "comfortable-villa-green",
      location: "Flyerin",
      features: {
        beds: "3",
        baths: "6",
        area: "200 sqft",
      },
      status: "For Sale",
      price: "4,600,000 SAR",
      isFeatured: "Featured",
    },
    {
      title: "Luxury Apartment",
      slug: "luxury-apartment",
      location: "Riyadh",
      features: {
        beds: "100",
        baths: "6",
        area: "200 sqft",
      },
      status: "For Sale",
      price: "3,200,000 SAR",
    },
  ];

  //fffffff
  return (
    <div className="text-center mx-auto py-12">
      <h1 className=" text-primary lg:mb-2 font-semibold">{t("SIMILAR LISTING")}</h1>
      <h2 className="text-[30px] md:text-[35px] lg:text-[40px] font-semibold mb-5">
        {t("Related")} <span className="text-primary ">{t("Properties")}</span>
      </h2>

      <div className="grid sm:grid-cols-2 md:grid-cols-3 gap-[20px] lg:gap-[30px] text-start ">
        {relatedProperties?.map((listing, index) => (
          <Card
            key={index}
            className="h-full py-0 rounded-t-xl gap-2 lg:gap-5 "
          >
            <div
              onClick={() => {
                if (typeof window !== "undefined" && listing?.slug) {
                  window.open(`/property/${listing.slug}`, "_blank");
                }
              }}
              className="h-[200px] lg:h-[240px] cursor-pointer w-full relative"
            >
              {/* {listing?.isFeatured ? (
                <div className="bg-primary absolute top-4 left-3 z-10 w-[100px] h-[30px] rounded">
                  <div className="flex items-center gap-2 text-white h-full justify-center">
                    <Image
                      width={13}
                      height={14}
                      src="/icons/listingCardIcons/Vector (2).png"
                      alt="featured"
                    />
                    <p className="text-[12px] font-semibold">
                      {listing?.isFeatured}
                    </p>
                  </div>
                </div>
              ) : null} */}

 {listing?.isFeatured && listing?.isFeatured !== "Normal" ? (
                  <div className="bg-primary absolute top-4 left-4 z-10 min-w-[80px] px-1 h-[30px] rounded">
                    <div className="flex items-center gap-2 text-white h-full justify-center">
                      <Image
                        width={13}
                        height={14}
                        src="/icons/listingCardIcons/Vector (2).png"
                        alt="featured"
                      />
                      <p className="text-[11px] font-semibold">
                        {listing?.isFeatured}
                      </p>
                    </div>
                  </div>
                ) : null}
                {listing?.type ? (
                  <div className="bg-secordary opacity-85 absolute top-4 right-4 z-10 w-[80px] h-[30px] px-2 rounded">
                    <div className="flex items-center gap-2 text-white h-full justify-center">
                      {/* <Image
                        width={13}
                        height={14}
                        src="/icons/listingCardIcons/Vector (2).png"
                        alt="featured"
                      /> */}
                      <p className="text-[10px] font-semibold">
                        {listing?.type}
                      </p>
                    </div>
                  </div>
                ) : null}

              <div className="bg-white absolute bottom-4 left-3 z-10 px-3 h-[30px] rounded">
                <div className="flex items-center h-full justify-center">
                  <p className="text-[12px] font-semibold">{listing?.price}</p>
                </div>
              </div>
              <Image
                src="/images/house/p2-570x370.jpg.png"
                fill
                alt="sadu-logo"
                className="cursor-pointer rounded-t-xl"
              />
            </div>
            <CardHeader
              onClick={() => {
                if (typeof window !== "undefined" && listing?.slug) {
                  window.open(`/property/${listing.slug}`, "_blank");
                }
              }}
              className="px-3 lg:px-5 cursor-pointer"
            >
              <h3 className="font-semibold text-[15px]">{listing.title}</h3>
              <p className="text-sm text-gray-500">{listing.location}</p>
            </CardHeader>
            <CardContent
              onClick={() => {
                if (typeof window !== "undefined" && listing?.slug) {
                  window.open(`/property/${listing.slug}`, "_blank");
                }
              }}
              className="px-3 lg:px-5 cursor-pointer"
            >
              <div className="flex items-center gap-5 border-b pb-4">
                {listing?.features?.beds &&
                <div className="flex items-center gap-1 ">
                  <Image
                    width={20}
                    height={18}
                    src="/icons/listingCardIcons/Vector (3).png"
                    alt="featured"
                  />
                  <p className="pt-1">{listing?.features?.beds}</p>
                </div>}
                {listing?.features?.baths &&
                <div className="flex items-center gap-1 ">
                  <Image
                    width={20}
                    height={18}
                    src="/icons/listingCardIcons/Vector (4).png"
                    alt="featured"
                  />
                  <p className="pt-1">{listing?.features?.baths}</p>
                </div>}
                {listing?.features?.area && 
                <div className="flex items-center gap-1 ">
                  <Image
                    width={20}
                    height={18}
                    src="/icons/listingCardIcons/Vector (5).png"
                    alt="featured"
                  />
                  <p className="pt-1">{listing?.features?.area}</p>
                </div>}
              </div>
            </CardContent>
            <CardFooter className="flex items-center justify-between px-3 lg:px-5">
              <h4 className="self-start text-[13px] font-bold text-primary">
                {listing.status}
              </h4>
              <div className="flex items-center gap-4 pb-5">
                <Image
                  onClick={() => router.push(`/property/${listing?.slug}`)}
                  width={19}
                  height={19}
                  src="/icons/listingCardIcons/Vector (6).png"
                  alt="featured"
                  className="cursor-pointer"
                />
                <Image
                  width={21}
                  height={18}
                  src="/icons/listingCardIcons/Vector (7).png"
                  alt="featured"
                />
                <Image
                  width={19}
                  height={19}
                  src="/icons/listingCardIcons/Vector (8).png"
                  alt="featured"
                />
              </div>
            </CardFooter>
          </Card>
        ))}
      </div>
      {/* <div className="flex items-center justify-center">
        <Button className="bg-primary mx-auto mt-10 text-white h-[50px] text-[16px] font-normal">
          Load More Listing
        </Button>
        </div> */}
    </div>
  );
}
