import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import Image from "next/image";
import React from "react";
import "./ServicesTypes.css";
const ServicesTypes = ({ activeTab, setActiveTab, service }) => {
 
  return (
    <div className="">
      <div className="grid sm:grid-cols-2 gap-3 sm:gap-6 md:gap-[30px] px-5 md:px-[50px] lg:px-[96px] mb-10 md:mb-16">
        {service?.tabs?.map((tab) => (
          <div
            key={tab}
            onClick={() => setActiveTab(tab)}
            className={`flex items-center gap-4 p-3 md:p-4 lg:p-[25px] rounded-2xl cursor-pointer ${
      activeTab === tab ? 'bg-primary text-white' : 'bg-white'
    }`}
            style={{ boxShadow: "10px 10px 30px 0px #0000001A" }}
          >
            <div className=" w-[50px] h-[50px] lg:w-[70px] lg:h-[70px] rounded-full bg-ligbg flex items-center justify-center  ">
              <Image
                width={27}
                height={27}
                src="/icons/ServicesIcons/Vector (10).png"
                alt="icon"
              />
            </div>

            <p className=" text-[16px] md:text-[20px] font-semibold"> {tab}</p>
          </div>
        ))}
      </div>
      <div className="mt-2 bg-ligbg py-10 md:py-16 text-center">
        <h1 className=" text-primary mb-2 font-semibold">SERVICES</h1>
        <h2 className="text-[30px] md:text-[35px]  lg:text-[40px] font-semibold mb-6">
         {service?.tabs? activeTab: service?.cardTitle}
        </h2>
        {/* <h2 className="text-[40px] font-semibold mb-6">
          <span className="text-primary">Services</span> for Buyers
        </h2> */}
        <div className="grid sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-5 px-5 md:px-[50px]  lg:px-[96px] ">
          {service.tabs? 
          (service.cards[activeTab].map((card, index) => (
            <Card
              key={index}
              className="service-type-card border-b-0 border-r-0 border-l-0 shadow-none gap-[18px] text-center px-4 pt-8 pb-10 border-t-10 border-primary rounded-sm hover:bg-primary hover:text-white"
            >
              <CardTitle className="text-[20px] font-bold text-primary hover:text-white service-type-name">
                {card?.title}
              </CardTitle>

              <CardContent className="px-0">
                <p className="text-center px-0 text-[14px]">
                  {card.desc}
                </p>
              </CardContent>
            </Card>
          )))
          : 
           (service.cards?.map((card, index) => (
            <Card
              key={index}
              className="service-type-card border-b-0 border-r-0 border-l-0 shadow-none gap-[18px] text-center px-6 pt-8 pb-10 border-t-10 border-primary rounded-sm hover:bg-primary hover:text-white"
            >
              <CardTitle className="text-[20px] font-bold text-primary hover:text-white service-type-name">
                {card?.title}
              </CardTitle>

              <CardContent className="px-0">
                <p className="text-center px-0 text-[14px]">
                  {card.desc}
                </p>
              </CardContent>
            </Card>
          )))
           }
        </div>
      </div>
    </div>
  );
};

export default ServicesTypes;

{
  /* <div
          className="flex items-center gap-4 bg-white p-[25px] rounded-2xl"
          style={{ boxShadow: "10px 10px 30px 0px #0000001A" }}
        >
          <div className="w-[70px] h-[70px] rounded-full bg-ligbg flex items-center justify-center  ">
            <Image
              width={27}
              height={27}
              src="/icons/ServicesIcons/Union.png"
              alt="icon"
            />
          </div>
          <p className="text-20px] font-semibold">Services for Seller</p>
        </div> */
}
