import { Geist, Geist_Mono, Poppins } from "next/font/google";
import "./globals.css";


const geistSans = Geist({
  variable: "--font-geist-sans",
  subsets: ["latin"],
});

const geistMono = Geist_Mono({
  variable: "--font-geist-mono",
  subsets: ["latin"],
});
const poppins = Poppins({
  subsets: ['latin'],
  weight: ['400', '500', '600', '700'], // add more if needed
  display: 'swap',
  variable: '--font-poppins', // optional for Tailwind
});


// export const metadata = {
//   title: "Sadu Real State",
//   description: "Generated by create next app",
//   icons: {
//     icon: '/favicon.png', 
//   },
// };
export const metadata = {
  title: "Sadu Real State",
  description: "Generated by create next app",
  icons: {
    icon: [
      { url: "/favicon.png", type: "image/png" },
      { url: "/favicon.ico", type: "image/x-icon" }, // fallback
    ],
  },
};


export default function RootLayout({ children,params }) {
    const locale = params?.locale || "en"; // fallback to English
  const dir = locale === "ar" ? "rtl" : "ltr";
  return (
    <html lang={locale} dir={dir}>
      <body className={poppins.className} >
      <div style={{maxWidth: '1560px', marginLeft: 'auto', marginRight:"auto"}}>

        {children}
      </div>
      </body>
    </html>
  );
}
